/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.function.pattern.Patterns;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import me.efnilite.skematic.utils.FaweTools;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Fill Region")
@Description(value={"Fill a region (selection) with a block."})
public class EffCuboidRegionFill
extends Effect {
    private Expression<CuboidRegion> region;
    private Expression<ItemType> pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.region = exprs[0];
        this.pattern = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.region.getSingle(e);
        ItemType item = (ItemType)this.pattern.getSingle(e);
        if (cuboid == null || item == null) {
            return;
        }
        World world = cuboid.getWorld();
        if (world == null) {
            return;
        }
        EditSession session = FaweTools.getEditSession(Bukkit.getServer().getWorld(world.getName()));
        SingleBlockPattern blockPattern = new SingleBlockPattern(new BaseBlock(BlockTypes.valueOf((String)item.toString()).getInternalId(), 0));
        session.setBlocks((Region)cuboid, Patterns.wrap((Pattern)blockPattern));
        session.flushQueue();
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "fill " + this.region.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffCuboidRegionFill.class, (String[])new String[]{"fill [all] [the] blocks in %cuboidregions% to %itemtype%"});
    }
}

