/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import me.efnilite.skematic.Skematic;

@Name(value="Schematic origin")
@Description(value={"Returns the origin location of a schematic (where it was copied and saved)"})
@Examples(value={"set {_origin} to the origin of \"plugins/WorldEdit/skematic.schematic\""})
@Since(value="1.0.0")
public class ExprSchematicOrigin
extends SimplePropertyExpression<String, Vector> {
    public Vector convert(String f) {
        try {
            return FaweAPI.load((File)new File(f)).getClipboard().getOrigin();
        }
        catch (FileNotFoundException exception) {
            Skematic.log("Schematic file '" + f + "' not found! Error:" + exception);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getPropertyName() {
        return "origin location";
    }

    public Class<Vector> getReturnType() {
        return Vector.class;
    }

    static {
        ExprSchematicOrigin.register(ExprSchematicOrigin.class, Vector.class, (String)"[s(ch|k)em[atic]] origin (location|area)", (String)"strings");
    }
}

