/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.object.schematic.Schematic;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Save schematic")
@Description(value={"Create a new schematic."})
@Examples(value={"save schematic selection of player to the file \"plugins/schematic.schematic\" with format schematic"})
@Since(value="1.1.0")
public class EffSaveSchematic
extends Effect {
    private Expression<CuboidRegion> region;
    private Expression<String> schematic;
    private Expression<ClipboardFormat> format;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.region = exprs[0];
        this.schematic = exprs[1];
        this.format = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion r = (CuboidRegion)this.region.getSingle(e);
        String t = (String)this.schematic.getSingle(e);
        if (t == null || r == null) {
            return;
        }
        ClipboardFormat cf = (ClipboardFormat)this.format.getSingle(e);
        if (cf == null) {
            cf = ClipboardFormat.SCHEMATIC;
        }
        Schematic s = new Schematic((Region)r);
        try {
            s.save(new File(t), cf);
        }
        catch (IOException ex) {
            Skematic.log("Could not save schematic " + (String)this.schematic.getSingle(e) + " with format " + cf, Level.SEVERE);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "create the schematic " + this.schematic.toString(e, debug) + ", with region " + this.region.toString(e, debug) + " with format " + this.format.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSaveSchematic.class, (String[])new String[]{"save [[the] s(ch|k)ematic] %cuboidregions% to [[the] file] %string% [with %-schematicformat% format]"});
    }
}

