/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="AsyncWorld - Delete")
@Description(value={"Delete an AsyncWorld."})
@Examples(value={"delete async world \"hi\""})
@Since(value="1.0.0")
public class EffDelAsyncWorld
extends Effect {
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.world = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        World w = (World)this.world.getSingle(e);
        if (w == null) {
            return;
        }
        w.getWorldFolder().delete();
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "delete the async world " + this.world.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffDelAsyncWorld.class, (String[])new String[]{"del[ete] [the] async[hronous] %world%"});
    }
}

