/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.World;
import me.efnilite.skematic.utils.FaweTools;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Clear contents")
@Description(value={"Clear the contents of a container at a location."})
@Examples(value={"clear the contents of the container at 3, 73, 12 in \"world\""})
@Since(value="1.0.0")
public class EffClearContainer
extends Effect {
    private Expression<World> world;
    private Expression<Location> position;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.position = exprs[0];
        this.world = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Location l = (Location)this.position.getSingle(e);
        World w = (World)this.world.getSingle(e);
        if (w == null || l == null) {
            return;
        }
        EditSession s = FaweTools.getEditSession(l.getWorld());
        s.clearContainerBlockContents(new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ()));
        s.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "clear the contents of the container at " + this.position.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffClearContainer.class, (String[])new String[]{"(clear|delete) [the] [(fawe|skematic)] content[s] of [the] [container] at %location%"});
    }
}

