/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Selection contains")
@Description(value={"Check whether the selection of a player contains a location."})
@Examples(value={"player's selection contains location 0, 0, 0 in \"World\""})
@Since(value="1.0.0")
public class CondSelectionContains
extends Condition {
    private Expression<Region> region;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.region = exprs[0];
        this.location = exprs[1];
        return true;
    }

    public boolean check(Event e) {
        Location l = (Location)this.location.getSingle(e);
        Region r = (Region)this.region.getSingle(e);
        if (r == null || l == null) {
            return false;
        }
        if (!r.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ())) {
            return !this.isNegated();
        }
        return this.isNegated();
    }

    public String toString(Event e, boolean debug) {
        return "test if " + this.location.toString(e, debug) + " is in the region " + this.region.toString(e, debug);
    }

    static {
        Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"%cuboidregions% contains %location%"});
    }
}

