/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import me.efnilite.skematic.Skematic;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Schematic dimensions")
@Description(value={"Gets one of the schematic dimensions (width, length or height)"})
@Examples(value={"set {_width} to the width of the skematic \"plugins/WorldEdit/skematic.schematic\""})
@Since(value="1.0.0")
public class ExprSchematicArea
extends SimpleExpression<Number> {
    private Expression<String> schematic;
    private Dimension dimension;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.dimension = Dimension.values()[parser.mark - 1];
        this.schematic = exprs[0];
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        Vector size;
        String s = (String)this.schematic.getSingle(e);
        if (s == null || this.dimension == null) {
            return null;
        }
        try {
            size = FaweAPI.load((File)new File(s)).getClipboard().getDimensions();
        }
        catch (FileNotFoundException exception) {
            Skematic.log("Schematic file " + s + " not found!");
            return null;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
        Double t = null;
        switch (this.dimension) {
            case WIDTH: {
                t = size.getY();
                break;
            }
            case HEIGHT: {
                t = size.getX();
                break;
            }
            case LENGTH: {
                t = size.getZ();
                break;
            }
            case FLOORSIZE: {
                t = size.getZ() * size.getX();
            }
        }
        return new Number[]{t};
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "schematic sizes of " + this.schematic.toString(event, debug);
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    static {
        Skript.registerExpression(ExprSchematicArea.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] (1\u00a6width|2\u00a6height|3\u00a6length|4\u00a6floor[(-| )]size) of [the] s(ch|k)em[atic] %string%"});
    }

    static enum Dimension {
        WIDTH,
        HEIGHT,
        LENGTH,
        FLOORSIZE;

    }
}

