/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Paste schematic")
@Description(value={"Paste a schematic at a location with or without using air"})
@Examples(value={"paste skematic \"plugins/WorldEdit/skematic.schematic\" at player excluding air"})
@Since(value="1.0.0")
public class EffPasteSchematic
extends Effect {
    private Expression<String> schematic;
    private Expression<Location> location;
    private Expression<Integer> angle;
    private Subarg arg;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.arg = Subarg.values()[parser.mark];
        this.schematic = exprs[0];
        this.location = exprs[1];
        this.angle = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        String file = (String)this.schematic.getSingle(e);
        Location l = (Location)this.location.getSingle(e);
        if (file == null || l == null) {
            return;
        }
        File s = new File(file);
        boolean ignoreAir = false;
        boolean allowUndo = false;
        switch (this.arg) {
            case AIR: {
                ignoreAir = true;
                break;
            }
            case UNDO: {
                allowUndo = true;
                break;
            }
            case BOTH: {
                ignoreAir = true;
                allowUndo = true;
                break;
            }
        }
        if (!file.endsWith(".schematic")) {
            s = new File(file + ".schematic");
        }
        Vector vector = new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ());
        if (this.angle != null) {
            CuboidClipboard clipboard;
            System.out.println("old");
            EditSession session = FaweAPI.getEditSessionBuilder((World)BukkitUtil.getLocalWorld((org.bukkit.World)l.getWorld())).autoQueue(Boolean.valueOf(true)).build();
            try {
                clipboard = SchematicFormat.getFormat((File)s).load(s);
            }
            catch (DataException | IOException ex) {
                return;
            }
            if (clipboard != null) {
                clipboard.rotate2D(((Integer)this.angle.getSingle(e)).intValue());
            }
            clipboard.paste(session, vector, ignoreAir);
            session.flushQueue();
        } else {
            try {
                FaweAPI.load((File)s).paste((World)BukkitUtil.getLocalWorld((org.bukkit.World)l.getWorld()), vector, allowUndo, ignoreAir, null);
            }
            catch (IOException ex) {
                Skematic.log("Could not paste schematic " + s, Level.SEVERE);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "paste the schematic " + this.schematic.toString(e, debug) + ", at location " + this.location.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPasteSchematic.class, (String[])new String[]{"paste [the] s(ch|k)em[atic] %string% at %location% [(1\u00a6(without|excluding) air)] [(2\u00a6[(,| and)] allow[ing] undo)] [[with] angle %-integer%]"});
    }

    static enum Subarg {
        NONE,
        AIR,
        UNDO,
        BOTH;

    }
}

