/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Flush Queue")
@Description(value={"Flush the queue of a player - clear it."})
@Examples(value={"flush player's queue"})
@Since(value="1.2")
public class EffFlush
extends Effect {
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        Player p = (Player)this.player.getSingle(e);
        if (p == null) {
            return;
        }
        FaweAPI.wrapPlayer((Object)p).getNewEditSession().flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "flush " + this.player.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffFlush.class, (String[])new String[]{"(flush|dequeue) [the] (queue of %player%|%player%'s queue)"});
    }
}

