/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Greenify")
@Description(value={"Greenify an area - Turns it into grass."})
@Examples(value={"greenify 2, 3, 4 in \"world\" within a radius of 20"})
@Since(value="1.0.0")
public class EffGreen
extends Effect {
    private Expression<World> world;
    private Expression<Location> position;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.position = exprs[0];
        this.radius = exprs[2];
        this.world = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Location l = (Location)this.position.getSingle(e);
        World w = (World)this.world.getSingle(e);
        Number r = (Number)this.radius.getSingle(e);
        if (r == null || w == null || l == null) {
            return;
        }
        EditSession s = FaweAPI.getEditSessionBuilder((World)w).autoQueue(Boolean.valueOf(true)).build();
        s.green(new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ()), ((Double)r).doubleValue());
        s.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "greenify " + this.position.toString(e, debug) + " with radius " + this.radius.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffGreen.class, (String[])new String[]{"(green|grass)[ify] %location% in %world% (in|within) [a] radius [of] %number%"});
    }
}

