/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.hooks.worldguard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import me.efnilite.skematic.hooks.worldguard.WorldGuard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Region owners")
@Description(value={"Gets/sets/removes/adds the owners of a region."})
@Examples(value={"add player to the owners of of region \"hub\" in \"Hubworld\""})
@Since(value="1.0.0")
public class ExprRegionOwners
extends SimpleExpression<Player> {
    private Expression<String> name;
    private Expression<World> world;
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.name = exprs[1];
        this.world = exprs[2];
        return true;
    }

    public Class getReturnType() {
        return Player.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(Event e, boolean debug) {
        return "set or remove " + this.player.toString(e, debug) + " of region " + this.name.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Player[].class});
        }
        return null;
    }

    protected Player[] get(Event e) {
        ProtectedRegion region = WorldGuard.getWorldGuard().getRegionManager(Bukkit.getServer().getWorld(((World)this.world.getSingle(e)).toString())).getRegion((String)this.name.getSingle(e));
        if (region != null && region.getOwners() != null) {
            return new Player[]{(Player)region.getOwners()};
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        DefaultDomain owners = new DefaultDomain();
        if (mode == Changer.ChangeMode.REMOVE) {
            ProtectedRegion region = WorldGuard.getWorldGuard().getRegionManager((World)this.world.getSingle(event)).getRegion((String)this.name.getSingle(event));
            if (region.getOwners() != null) {
                for (String owner : region.getOwners().getPlayers()) {
                    owners.addPlayer(owner);
                }
            }
            owners.removePlayer(this.player.toString());
            region.setOwners(owners);
        } else if (mode == Changer.ChangeMode.ADD) {
            ProtectedRegion region = WorldGuard.getWorldGuard().getRegionManager((World)this.world.getSingle(event)).getRegion((String)this.name.getSingle(event));
            if (region.getOwners() != null) {
                for (String owner : region.getOwners().getPlayers()) {
                    owners.addPlayer(owner);
                }
            }
            owners.addPlayer(this.player.toString());
            region.setOwners(owners);
        }
    }

    static {
        Skript.registerExpression(ExprRegionOwners.class, Player.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"owners of region %string% in %world%"});
    }
}

