/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.hooks.worldguard.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldguard.protection.managers.RegionManager;
import me.efnilite.skematic.hooks.worldguard.WorldGuard;
import me.efnilite.skematic.util.TaskManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

@Name(value="Region - Delete")
@Description(value={"Delete a region."})
@Examples(value={"delete region \"newregion\" in \"world\""})
@Since(value="1.0.0")
public class EffDelRegion
extends Effect {
    private Expression<String> name;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "delete region " + this.name.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    protected void execute(Event e) {
        TaskManager.manager.async(() -> {
            RegionManager regionManager = WorldGuard.getWorldGuard().getRegionManager(Bukkit.getServer().getWorld(((World)this.world.getSingle(e)).toString()));
            if (regionManager != null) {
                regionManager.removeRegion((String)this.name.getSingle(e));
            }
        });
    }

    static {
        Skript.registerEffect(EffDelRegion.class, (String[])new String[]{"del[ete] [the] [worldguard] region [(named|call)] %string% in %world%"});
    }
}

