/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.hooks.worldguard.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.object.FawePlayer;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import me.efnilite.skematic.hooks.worldguard.WorldGuard;
import me.efnilite.skematic.util.TaskManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Region - create")
@Description(value={"Create a region."})
@Examples(value={"create region \"newregion\" in \"world\""})
@Since(value="1.0.0")
public class EffCreateRegion
extends Effect {
    private Expression<Player> player;
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.player = exprs[1];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "create the new region called " + this.name.toString(event, debug) + " by player " + this.player.toString(event, debug);
    }

    protected void execute(Event e) {
        Player p = (Player)this.player.getSingle(e);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion((String)this.name.getSingle(e), new BlockVector(FawePlayer.wrap((Object)p).getSelection().getMaximumPoint()), new BlockVector(FawePlayer.wrap((Object)p).getSelection().getMinimumPoint()));
        TaskManager.manager.async(() -> {
            DefaultDomain owners = new DefaultDomain();
            if (WorldGuard.getWorldGuard().wrapPlayer(p) != null) {
                owners.addPlayer(WorldGuard.getWorldGuard().wrapPlayer(p));
                region.setOwners(owners);
                WorldGuard.getWorldGuard().getRegionManager(Bukkit.getServer().getWorld(FaweAPI.wrapPlayer((Object)p).getSession().getSelectionWorld().toString())).addRegion((ProtectedRegion)region);
            }
        });
    }

    static {
        Skript.registerEffect(EffCreateRegion.class, (String[])new String[]{"create [the] [new] [worldguard] region [(named|called)] %string% with [the] (selection of %player%|%player%'s selection)]"});
    }
}

