/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import me.efnilite.skematic.Skematic;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Schematic dimensions")
@Description(value={"Gets one of the schematic dimensions (width, length or height)"})
@Examples(value={"set {_width} to the width of the skematic \"plugins/WorldEdit/skematic.schematic\""})
@Since(value="1.0.0")
public class ExprSchematicArea
extends SimpleExpression<Number> {
    private Expression<String> schem;
    private int marker;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.marker = parser.mark;
        this.schem = exprs[0];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "schematic sizes of " + this.schem.toString(event, debug);
    }

    @Nullable
    protected Number[] get(Event event) {
        Vector size;
        File file = new File((String)this.schem.getSingle(event));
        try {
            size = FaweAPI.load((File)file).getClipboard().getDimensions();
        }
        catch (FileNotFoundException exception) {
            Skematic.log("Schematic file '" + file + "' not found! Error:" + exception);
            return null;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
        Double result = null;
        switch (this.marker) {
            case 1: {
                result = size.getY();
                break;
            }
            case 2: {
                result = size.getX();
                break;
            }
            case 3: {
                result = size.getZ();
                break;
            }
            case 4: {
                result = size.getZ() * size.getX();
            }
        }
        return new Number[]{result};
    }

    static {
        Skript.registerExpression(ExprSchematicArea.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] (1\u00a6width|2\u00a6height|3\u00a6length) of [the] [(sc|k)hem[atic]] %string%"});
    }
}

