/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.event.Event;

@Name(value="Selection points")
@Description(value={"Gets the minimal or maximal points of a player's selection"})
@Examples(value={"set {_point} to the maximum point of player's selection"})
@Since(value="1.0.0")
public class ExprRegionPoints
extends SimpleExpression<Vector> {
    private Expression<Region> player;
    private Point point;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.point = Point.values()[parseResult.mark];
        this.player = exprs[0];
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "get the min and max points of the region of " + this.player.toString(e, debug);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    protected Vector[] get(Event e) {
        Vector r = null;
        switch (this.point) {
            case MAX: {
                r = FaweAPI.wrapPlayer((Object)this.player.getSingle(e)).getSelection().getMinimumPoint();
                break;
            }
            case MIN: {
                r = FaweAPI.wrapPlayer((Object)this.player.getSingle(e)).getSelection().getMaximumPoint();
            }
        }
        return new Vector[]{r};
    }

    static {
        Skript.registerExpression(ExprRegionPoints.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s] of (selection of %player%|%player%'s selection)", "(selection of %player%|%player%'s selection)'[s] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s]"});
    }

    static enum Point {
        MIN,
        MAX;

    }
}

