/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Selection dimensions")
@Description(value={"Get one of the region dimensions of a player's selection."})
@Examples(value={"set {area} to the length of player's selection"})
@Since(value="1.0.0")
public class ExprRegionDimensions
extends SimpleExpression<Number> {
    private Expression<Player> player;
    private Dimension dimension;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.dimension = Dimension.values()[parseResult.mark];
        this.player = exprs[0];
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "get the dimensions of the selection of " + this.player.toString(e, debug);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected Number[] get(Event e) {
        Integer result = null;
        switch (this.dimension) {
            case LONG: {
                result = FaweAPI.wrapPlayer((Object)this.player.getSingle(e)).getSelection().getLength();
                break;
            }
            case HIGH: {
                result = FaweAPI.wrapPlayer((Object)this.player.getSingle(e)).getSelection().getHeight();
                break;
            }
            case WIDE: {
                result = FaweAPI.wrapPlayer((Object)this.player.getSingle(e)).getSelection().getWidth();
            }
        }
        return new Number[]{result};
    }

    static {
        Skript.registerExpression(ExprRegionDimensions.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6length|2\u00a6height|3\u00a6width) of (%player%'s selection|selection of %player%)"});
    }

    static enum Dimension {
        LONG,
        HIGH,
        WIDE;

    }
}

