/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Selection contains")
@Description(value={"Check whether the selection of a player contains a location."})
@Examples(value={"player's selection contains location 0, 0, 0 in \"World\""})
@Since(value="1.0.0")
public class CondSelectionContains
extends Condition {
    private Expression<Player> player;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.location = exprs[1];
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "test if " + this.location.toString(e, debug) + " is in the selection of " + this.player.toString(e, debug);
    }

    public boolean check(Event e) {
        Location pos = (Location)this.location.getSingle(e);
        if (!FaweAPI.wrapPlayer((Object)this.player.toString()).getSelection().contains(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ())) {
            return !this.isNegated();
        }
        return this.isNegated();
    }

    static {
        Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"(%player%'s selection|selection of %player%) contains %location%"});
    }
}

