/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprLightLevel
extends SimpleExpression<Number> {
    private Expression<World> world;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.world = exprs[1];
        this.location = exprs[0];
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "light level of block at " + this.location.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected Number[] get(Event e) {
        Location pos = (Location)this.location.getSingle(e);
        return new Number[]{FaweAPI.getWorld((String)this.world.toString()).getBlockLightLevel(new Vector(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()))};
    }

    static {
        Skript.registerExpression(ExprLightLevel.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [block(-| )]light of [the] [block] (at|of) %location%"});
    }
}

