/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EffPasteSchematic
extends Effect {
    private Expression<String> schematic;
    private Expression<Location> location;
    private Subarg arg;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.arg = Subarg.values()[parser.mark];
        this.schematic = exprs[0];
        this.location = exprs[1];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "paste the schematic " + this.schematic.toString(event, debug) + ", at location " + this.location.toString(event, debug);
    }

    protected void execute(Event e) {
        boolean ignoreAir = false;
        boolean allowUndo = false;
        switch (this.arg) {
            case AIR: {
                ignoreAir = true;
                break;
            }
            case UNDO: {
                allowUndo = true;
                break;
            }
            case BOTH: {
                ignoreAir = true;
                allowUndo = true;
                break;
            }
        }
        String s = ((String)this.schematic.getSingle(e)).replace("\"", "");
        Location l = (Location)this.location.getSingle(e);
        if (!s.endsWith(".schematic")) {
            s = s + ".schematic";
        }
        try {
            FaweAPI.load((File)new File(s)).paste((World)BukkitUtil.getLocalWorld((org.bukkit.World)l.getWorld()), new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ()), allowUndo, ignoreAir, null);
        }
        catch (IOException ex) {
            Skematic.log("Could not paste schematic " + (String)this.schematic.getSingle(e) + ". Exception: " + ex.toString(), Level.SEVERE);
        }
    }

    static {
        Skript.registerEffect(EffPasteSchematic.class, (String[])new String[]{"paste [the] s(ch|k)em[atic] %string% at %location% [(1\u00a6(without|excluding) air)] [(2\u00a6[(,| and)] allow[ing] undo)]"});
    }

    static enum Subarg {
        NONE,
        AIR,
        UNDO,
        BOTH;

    }
}

