/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.hooks.worldguard.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.object.FawePlayer;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;
import me.efnilite.skematic.hooks.worldguard.WorldGuard;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EffCreateRegion
extends Effect {
    private Expression<Player> player;
    private Expression<World> world;
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.player = exprs[1];
        if (exprs[2] != null) {
            this.world = exprs[2];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "create the new region called " + this.name.toString(event, debug) + " by player " + this.player.toString(event, debug) + " with world " + this.world.toString(event, debug);
    }

    protected void execute(Event e) {
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(this.name.toString(), new BlockVector(FawePlayer.wrap(this.player).getSelection().getMaximumPoint()), new BlockVector(FawePlayer.wrap(this.player).getSelection().getMinimumPoint()));
        DefaultDomain owners = new DefaultDomain();
        try {
            owners.addPlayer(WorldGuard.getWorldGuard().wrapPlayer((Player)this.player.getSingle(e)));
        }
        catch (NullPointerException exception) {
            Skematic.log("Could not add " + this.player.toString() + " to the owners of region " + region.toString(), Level.SEVERE);
        }
        region.setOwners(owners);
        if (this.world == null) {
            this.world = (Expression)((Player)this.player.getSingle(e)).getWorld();
        }
        WorldGuard.getWorldGuard().getRegionManager((World)this.world.getSingle(e)).addRegion((ProtectedRegion)region);
    }

    static {
        Skript.registerEffect(EffCreateRegion.class, (String[])new String[]{"create [the] [new] [worldguard] region [(named|called)] %string% with [the] [sel[ection]] of %player% [(with|and) %world%]"});
    }
}

