/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EffPasteSchematic
extends Effect {
    private Expression<String> schematic;
    private Expression<Location> location;
    private Expression<Boolean> air;
    private Expression<Boolean> redo;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.schematic = exprs[0];
        this.location = exprs[1];
        this.air = exprs[2];
        this.redo = exprs[3];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "paste the schematic " + this.schematic.toString(event, debug) + ", at location " + this.location.toString(event, debug) + " with air " + this.air.toString(event, debug) + " and with redo " + this.redo.toString(event, debug);
    }

    protected void execute(Event event) {
        Skematic.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)Skematic.getInstance(), () -> {
            File schematic = new File(this.schematic.toString());
            if (!this.schematic.toString().endsWith(".schematic")) {
                schematic = new File(this.schematic.toString() + ".schematic");
            }
            try {
                FaweAPI.load((File)schematic).paste((World)new BukkitWorld(((Location)this.location.getSingle(event)).getWorld()), new Vector(((Location)this.location.getSingle(event)).getX(), ((Location)this.location.getSingle(event)).getY(), ((Location)this.location.getSingle(event)).getZ()), new Boolean(this.redo.toString()).booleanValue(), new Boolean(this.air.toString()).booleanValue(), null);
            }
            catch (FileNotFoundException exception) {
                Skematic.log("Could not find file '" + schematic + "'", Level.SEVERE);
            }
            catch (IOException exception) {
                Skematic.log("Could not paste schematic '" + schematic + "'", Level.SEVERE);
            }
        });
    }

    static {
        Skript.registerEffect(EffPasteSchematic.class, (String[])new String[]{"paste [a] [new] schem[atic] %string% at %location% [(without|excluding) air %-boolean%[(,| and) allow[ing] undo %-boolean%]]"});
    }
}

