/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skellettproxy;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import me.limeglass.skellettproxy.BungeeEventPacket;
import me.limeglass.skellettproxy.BungeeEventPacketType;
import me.limeglass.skellettproxy.BungeeEventRunner;
import me.limeglass.skellettproxy.ConnectedServer;
import me.limeglass.skellettproxy.ServerTracker;
import me.limeglass.skellettproxy.SkellettProxy;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;

public class VariableStorage {
    private static String folder = String.valueOf(SkellettProxy.getInstance().getDataFolder().getAbsolutePath()) + File.separator + "variables" + File.separator;
    private static File file;
    private static final String NEW_LINE = "\n";
    private static final String DELIMITER = ": ";
    private static FileWriter writer;
    private static GsonBuilder gsonBuilder;
    private static Gson gson;
    public static TreeMap<String, Object> variables;
    private static Boolean loadingHash;

    static {
        writer = null;
        gsonBuilder = new GsonBuilder();
        variables = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        loadingHash = false;
    }

    public static FileWriter getWriter() {
        return writer;
    }

    public static Object get(String ID) {
        return variables.get(ID);
    }

    public static Integer getSize() {
        return variables.size();
    }

    public static void save(Boolean running, Boolean reboot) {
        if (running.booleanValue()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Date date = new Date();
        File newFile = new File(String.valueOf(folder) + File.separator + "backups" + File.separator + date.toString().replaceAll(":", "-") + ".csv");
        try {
            Files.copy(file.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reboot.booleanValue()) {
            VariableStorage.load();
        }
    }

    public static void setup() {
        file = new File(String.valueOf(folder) + "variables.csv");
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.IDENTITY);
        gson = gsonBuilder.create();
        if (!file.exists()) {
            try {
                try {
                    writer = new FileWriter(file);
                    writer.append(NEW_LINE);
                    writer.append("# SkellettProxy's variable database.");
                    writer.append(NEW_LINE);
                    writer.append("# Please do not modify this file manually, thank you!");
                    writer.append(NEW_LINE);
                    writer.append(NEW_LINE);
                    SkellettProxy.debugMessage("Successfully created CSV variables database!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        writer.flush();
                    }
                    catch (IOException e2) {
                        SkellettProxy.debugMessage("Error flushing data during setup!");
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    SkellettProxy.debugMessage("Error flushing data during setup!");
                    e.printStackTrace();
                }
            }
        } else {
            VariableStorage.load();
        }
    }

    private static void load() {
        String line = "";
        BufferedReader reader = null;
        try {
            try {
                ArrayList<String[]> data = new ArrayList<String[]>();
                reader = new BufferedReader(new FileReader(file));
                int i = 0;
                while (i < 4) {
                    reader.readLine();
                    ++i;
                }
                while ((line = reader.readLine()) != null) {
                    String[] values = line.split(DELIMITER, 2);
                    data.add(values);
                }
                writer = new FileWriter(file);
                writer.append(NEW_LINE);
                writer.append("# SkellettProxy's variable database.");
                writer.append(NEW_LINE);
                writer.append("# Please do not modify this file manually, thank you!");
                writer.append(NEW_LINE);
                writer.append(NEW_LINE);
                for (String[] varaibleData : data) {
                    VariableStorage.write(varaibleData[0], gson.fromJson(varaibleData[1], Object.class));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    SkellettProxy.debugMessage("Error closing reader while loading!");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                SkellettProxy.debugMessage("Error closing reader while loading!");
                e.printStackTrace();
            }
        }
    }

    private static void loadFromHash() {
        block13: {
            loadingHash = true;
            try {
                try {
                    writer = new FileWriter(file);
                    writer.append(NEW_LINE);
                    writer.append("# SkellettProxy's variable database.");
                    writer.append(NEW_LINE);
                    writer.append("# Please do not modify this file manually, thank you!");
                    writer.append(NEW_LINE);
                    writer.append(NEW_LINE);
                    if (!variables.isEmpty()) {
                        for (String ID : variables.keySet()) {
                            VariableStorage.write(ID, variables.get(ID));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        writer.flush();
                    }
                    catch (IOException e2) {
                        SkellettProxy.debugMessage("Error flushing writer while loading from hash!");
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    SkellettProxy.debugMessage("Error flushing writer while loading from hash!");
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                writer.flush();
            }
            catch (IOException e) {
                SkellettProxy.debugMessage("Error flushing writer while loading from hash!");
                e.printStackTrace();
            }
        }
        loadingHash = false;
    }

    public static void remove(String ID) {
        if (variables.containsKey(ID) && !loadingHash.booleanValue()) {
            try {
                VariableStorage.getWriter().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            variables.remove(ID);
            VariableStorage.loadFromHash();
        }
    }

    public static void write(String ID, Object value) {
        if (ID == null || value == null) {
            return;
        }
        if (SkellettProxy.getConfig().getBoolean("NetworkVariables.AutomaticSharing", false) && !ServerTracker.isEmpty().booleanValue()) {
            for (ConnectedServer s : ServerTracker.getAll()) {
                if (!s.isUsingEvents().booleanValue()) continue;
                BungeeEventPacket packet = new BungeeEventPacket(false, ID, value, BungeeEventPacketType.UPDATEVARIABLES);
                BungeeEventRunner.send(s, packet);
            }
        }
        if (variables.containsKey(ID) && !loadingHash.booleanValue()) {
            if (SkellettProxy.getConfig().getBoolean("NetworkVariables.AllowOverrides", true)) {
                try {
                    VariableStorage.getWriter().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                variables.remove(ID);
                VariableStorage.loadFromHash();
            } else {
                return;
            }
        }
        variables.put(ID, value);
        try {
            try {
                writer.append(ID);
                writer.append(DELIMITER);
                writer.append(gson.toJson(value));
                writer.append(NEW_LINE);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    writer.flush();
                }
                catch (IOException e2) {
                    SkellettProxy.debugMessage("Error flushing data while writing!");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                SkellettProxy.debugMessage("Error flushing data while writing!");
                e.printStackTrace();
            }
        }
    }

    public static void run() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (SkellettProxy.getConfig().getBoolean("NetworkVariables.Backups.ConsoleMessage", false)) {
                    SkellettProxy.sendConsoleMessage("Variables have been saved!");
                }
                VariableStorage.save(true, true);
            }
        };
        BungeeCord.getInstance().getScheduler().schedule((Plugin)SkellettProxy.getInstance(), task, SkellettProxy.getConfig().getLong("NetworkVariables.Backups.IntervalTime", 60L), 1L, TimeUnit.MINUTES);
    }
}

