/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skellettproxy;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.limeglass.skellettproxy.ConnectedServer;
import me.limeglass.skellettproxy.SkellettProxy;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;

public class ServerTracker {
    private static List<ConnectedServer> servers = new ArrayList<ConnectedServer>();
    private static List<ConnectedServer> notRespondingServers = new ArrayList<ConnectedServer>();
    private static HashMap<ConnectedServer, Long> tracker = new HashMap();

    public static void tracker() {
        BungeeCord.getInstance().getScheduler().schedule((Plugin)SkellettProxy.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!servers.isEmpty()) {
                    for (ConnectedServer server : servers) {
                        if (tracker.containsKey(server)) {
                            long trys = SkellettProxy.getConfig().getLong("AllowedTrys", 4L);
                            long lastupdated = (Long)tracker.get(server) + trys * (long)server.getHeartbeat().intValue();
                            if (lastupdated >= System.currentTimeMillis() || notRespondingServers.contains(server)) continue;
                            SkellettProxy.debugMessage("Server " + server.getName() + " has stopped responding!");
                            if (SkellettProxy.getConfig().getBoolean("DisableTracking", false)) {
                                ServerTracker.remove(server);
                                continue;
                            }
                            notRespondingServers.add(server);
                            continue;
                        }
                        tracker.put(server, System.currentTimeMillis() + (long)(5 * server.getHeartbeat()));
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void dump() {
        tracker.clear();
        servers.clear();
        notRespondingServers.clear();
    }

    public static Boolean update(String string) {
        ConnectedServer server = ServerTracker.get(string);
        if (server != null) {
            if (tracker.containsKey(server)) {
                tracker.remove(server);
            }
            tracker.put(server, System.currentTimeMillis());
            if (notRespondingServers.contains(server)) {
                notRespondingServers.remove(server);
                SkellettProxy.debugMessage(String.valueOf(server.getName()) + " started responding again!");
            } else {
                SkellettProxy.debugMessage("Updated server " + string + " AND " + System.currentTimeMillis());
            }
            return false;
        }
        return true;
    }

    public static ConnectedServer get(String server) {
        if (!servers.isEmpty()) {
            for (ConnectedServer s : servers) {
                if (!s.getName().equals(server)) continue;
                return s;
            }
        }
        return null;
    }

    public static ConnectedServer getByAddress(InetAddress server) {
        if (!servers.isEmpty()) {
            for (ConnectedServer s : servers) {
                if (s.getAddress() != server) continue;
                return s;
            }
        }
        return null;
    }

    public static Boolean isEmpty() {
        return servers.isEmpty();
    }

    public static List<ConnectedServer> getAll() {
        return servers;
    }

    public static Boolean contains(ConnectedServer server) {
        if (servers.contains(server)) {
            return true;
        }
        return false;
    }

    public static Boolean isResponding(ConnectedServer server) {
        if (notRespondingServers.contains(server)) {
            return false;
        }
        return true;
    }

    public static void add(ConnectedServer server) {
        if (!servers.contains(server)) {
            servers.add(server);
            SkellettProxy.sendConsoleMessage("Connected to server " + server.getName() + " with port " + server.getPort());
        }
    }

    public static void remove(ConnectedServer server) {
        if (tracker.containsKey(server)) {
            tracker.remove(server);
        }
        if (notRespondingServers.contains(server)) {
            notRespondingServers.remove(server);
        }
        if (servers.contains(server)) {
            servers.remove(server);
            SkellettProxy.debugMessage("Removed ConnectedServer " + server.getName() + " with port " + server.getPort());
        }
    }
}

