/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skellettproxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import me.limeglass.skellettproxy.BungeeEventPacket;
import me.limeglass.skellettproxy.ConnectedServer;
import me.limeglass.skellettproxy.SkellettProxy;

public class BungeeEventRunner {
    private static Socket client;

    public static Object send(ConnectedServer server, BungeeEventPacket packet) {
        if (!BungeeEventRunner.isOpen(server.getAddress(), server.getEventPort()).booleanValue()) {
            SkellettProxy.sendConsoleMessage("&cCould not send packet " + (Object)((Object)packet.getType()) + " to socket at " + server.getAddress() + ":" + server.getEventPort() + ". Due to closed socket on other side.");
            return null;
        }
        Object returnData = null;
        try {
            client = new Socket(server.getAddress().getHostAddress(), (int)server.getEventPort());
            ObjectOutputStream objOUT = new ObjectOutputStream(client.getOutputStream());
            ObjectInputStream objIN = new ObjectInputStream(client.getInputStream());
            objOUT.writeObject(packet);
            if (packet.isSettable().booleanValue()) {
                returnData = objIN.readObject();
            }
            objOUT.close();
            objIN.close();
            client.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return returnData;
    }

    public static Object sendToAddress(InetAddress address, Integer port, BungeeEventPacket packet) {
        if (!BungeeEventRunner.isOpen(address, port).booleanValue()) {
            SkellettProxy.sendConsoleMessage("&cCould not send packet " + (Object)((Object)packet.getType()) + " to socket at " + address + ":" + port + ". Due to closed socket on other side.");
            return null;
        }
        Object returnData = null;
        try {
            client = new Socket(address, (int)port);
            ObjectOutputStream objOUT = new ObjectOutputStream(client.getOutputStream());
            ObjectInputStream objIN = new ObjectInputStream(client.getInputStream());
            objOUT.writeObject(packet);
            if (packet.isSettable().booleanValue()) {
                returnData = objIN.readObject();
            }
            objOUT.close();
            objIN.close();
            client.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return returnData;
    }

    public static Boolean isOpen(InetAddress address, Integer port) {
        Boolean result = false;
        try {
            Socket attempt = new Socket();
            attempt.connect(new InetSocketAddress(address, (int)port));
            attempt.close();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

