/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skellettproxy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import me.limeglass.skellettproxy.BungeeEventPacket;
import me.limeglass.skellettproxy.BungeeEventPacketType;
import me.limeglass.skellettproxy.BungeeEventRunner;
import me.limeglass.skellettproxy.ConnectedServer;
import me.limeglass.skellettproxy.ServerTracker;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeeEventListener
implements Listener {
    @EventHandler
    public void onDisconnect(PlayerDisconnectEvent event) {
        BungeeEventPacket packet = new BungeeEventPacket(false, event.getPlayer().getUniqueId(), event.getPlayer().getName(), BungeeEventPacketType.PLAYERDISCONNECT);
        for (ConnectedServer s : ServerTracker.getAll()) {
            if (!s.isUsingEvents().booleanValue()) continue;
            BungeeEventRunner.send(s, packet);
        }
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent event) {
        BungeeEventPacket packet = new BungeeEventPacket(false, event.getPlayer().getUniqueId(), event.getPlayer().getName(), BungeeEventPacketType.PLAYERSWITCH);
        for (ConnectedServer s : ServerTracker.getAll()) {
            if (!s.isUsingEvents().booleanValue()) continue;
            BungeeEventRunner.send(s, packet);
        }
    }

    @EventHandler
    public void onChat(ChatEvent event) {
        if (event.getMessage().startsWith("/")) {
            String command = event.getMessage().split("/")[1].toLowerCase();
            if (command.contains(" ")) {
                String[] splits = command.split(" ");
                command = splits[0];
            }
            ProxiedPlayer player = (ProxiedPlayer)event.getSender();
            ArrayList<Serializable> data = new ArrayList<Serializable>(Arrays.asList(player.getUniqueId(), command));
            BungeeEventPacket packet = new BungeeEventPacket(false, player.getName(), data, BungeeEventPacketType.PLAYERCOMMAND);
            for (ConnectedServer s : ServerTracker.getAll()) {
                if (!s.isUsingEvents().booleanValue()) continue;
                BungeeEventRunner.send(s, packet);
            }
        } else {
            for (ConnectedServer s : ServerTracker.getAll()) {
                if (!s.isUsingEvents().booleanValue()) continue;
                ArrayList<Object> data = new ArrayList<Object>(Arrays.asList(null, null));
                if (event.getSender() instanceof ProxiedPlayer && event.getReceiver() instanceof ProxiedPlayer) {
                    data = new ArrayList<Serializable>(Arrays.asList(((ProxiedPlayer)event.getSender()).getUniqueId(), event.getMessage(), ((ProxiedPlayer)event.getReceiver()).getUniqueId()));
                } else if (event.getSender() instanceof ProxiedPlayer) {
                    data = new ArrayList<Serializable>(Arrays.asList(((ProxiedPlayer)event.getSender()).getUniqueId(), event.getMessage(), null));
                } else if (event.getReceiver() instanceof ProxiedPlayer) {
                    data = new ArrayList<Serializable>(Arrays.asList(null, event.getMessage(), ((ProxiedPlayer)event.getReceiver()).getUniqueId()));
                }
                BungeeEventPacket packet = new BungeeEventPacket(false, data, BungeeEventPacketType.PLAYERCHAT);
                BungeeEventRunner.send(s, packet);
            }
        }
    }
}

