/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass;

import com.gmail.thelimeglass.BungeeEventListener;
import com.gmail.thelimeglass.BungeeEventPacket;
import com.gmail.thelimeglass.BungeeEventPacketType;
import com.gmail.thelimeglass.BungeeEventRunner;
import com.gmail.thelimeglass.ConnectedServer;
import com.gmail.thelimeglass.Metrics;
import com.gmail.thelimeglass.ServerTracker;
import com.gmail.thelimeglass.SocketRunnable;
import com.gmail.thelimeglass.VariableStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class SkellettProxy
extends Plugin {
    public static Configuration config;
    private static ServerSocket server;
    private static SkellettProxy instance;
    private static File globalScripts;

    public void onEnable() {
        InputStream in;
        Object var6_11;
        File file;
        int index;
        File scripts;
        String path;
        instance = this;
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeEventListener());
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(globalScripts = new File((path = (scripts = new File(this.getDataFolder(), "scripts" + File.separator + "skellett.sk")).getPath()).substring(0, index = path.lastIndexOf(File.separator)))).exists()) {
            globalScripts.mkdirs();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                Throwable throwable = null;
                var6_11 = null;
                try {
                    in = this.getResourceAsStream("config.yml");
                    try {
                        SkellettProxy.sendConsoleMessage("&cNo config was found, generating a new config...");
                        Files.copy(in, file.toPath(), new CopyOption[0]);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!this.getDescription().getVersion().equals(config.getString("version"))) {
            SkellettProxy.sendConsoleMessageEmpty();
            SkellettProxy.sendConsoleMessage("&eThere is a new SkellettProxy version. Generating new config...");
            SkellettProxy.sendConsoleMessageEmpty();
            try {
                Throwable e1 = null;
                var6_11 = null;
                try {
                    in = this.getResourceAsStream("config.yml");
                    try {
                        Files.delete(file.toPath());
                        Files.copy(in, file.toPath(), new CopyOption[0]);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e1 == null) {
                        e1 = throwable;
                    } else if (e1 != throwable) {
                        e1.addSuppressed(throwable);
                    }
                    throw e1;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (config.getBoolean("NetworkVariables.Enabled", false)) {
            File backups;
            File folder = new File(this.getDataFolder(), "variables");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!(backups = new File(this.getDataFolder(), "variables" + File.separator + "backups" + File.separator)).exists()) {
                backups.mkdirs();
            }
            VariableStorage.setup();
            if (config.getBoolean("NetworkVariables.Backups.Interval", false)) {
                VariableStorage.run();
            }
            SkellettProxy.sendConsoleMessage("Loaded " + VariableStorage.getSize() + " network variables!");
        }
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new Metrics.SimplePie("amount_of_plugins"){

            @Override
            public String getValue() {
                return String.valueOf(SkellettProxy.getInstance().getProxy().getPluginManager().getPlugins().size());
            }
        });
        metrics.addCustomChart(new Metrics.SingleLineChart("amount_of_network_variables"){

            @Override
            public int getValue() {
                return VariableStorage.getSize();
            }
        });
        metrics.addCustomChart(new Metrics.SingleLineChart("amount_of_global_scripts"){

            @Override
            public int getValue() {
                return SkellettProxy.getScripts().size();
            }
        });
        SkellettProxy.debugMessage("Starting Skellett connection...");
        BungeeCord.getInstance().getScheduler().runAsync((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Socket socket = null;
                try {
                    server = new ServerSocket(config.getInt("Port", 7332));
                    SkellettProxy.sendConsoleMessage("SkellettProxy connection established on port " + config.getInt("Port", 7332));
                    while (!server.isClosed()) {
                        try {
                            socket = server.accept();
                            new Thread(new SocketRunnable(socket)).start();
                        }
                        catch (SocketException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        ServerTracker.tracker();
    }

    public void onDisable() {
        ServerTracker.dump();
        if (config.getBoolean("NetworkVariables.Backups.End", true)) {
            VariableStorage.save(true, false);
        }
    }

    public static SkellettProxy getInstance() {
        return instance;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static ServerSocket getSocket() {
        return server;
    }

    public static File getScriptsFolder() {
        return globalScripts;
    }

    public static List<File> getScripts() {
        return Arrays.asList(globalScripts.listFiles());
    }

    public static void globalScripts(ConnectedServer server) {
        if (SkellettProxy.getConfig().getBoolean("GlobalScripts.Enabled") && globalScripts.listFiles().length > 0) {
            HashMap<String, List<String>> data = new HashMap<String, List<String>>();
            for (File script : SkellettProxy.getScripts()) {
                try {
                    data.put(script.getName(), Files.readAllLines(script.toPath(), Charset.defaultCharset()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            BungeeEventPacket packet = new BungeeEventPacket(false, data, BungeeEventPacketType.GLOBALSCRIPTS);
            if (server.isUsingEvents().booleanValue()) {
                BungeeEventRunner.send(server, packet);
            }
        }
    }

    public static void sendConsoleMessageEmpty() {
        ProxyServer.getInstance().getLogger().info("");
    }

    public static void sendConsoleMessage(String message) {
        ProxyServer.getInstance().getLogger().info(String.valueOf(SkellettProxy.cc("&8[&aSkellett&8] &7")) + SkellettProxy.cc(message));
    }

    public static void debugMessage(String message) {
        if (config.getBoolean("debug", false)) {
            ProxyServer.getInstance().getLogger().info(String.valueOf(SkellettProxy.cc("&8[&eSkellettDebug&8] &7")) + SkellettProxy.cc(message));
        }
    }

    public static ServerInfo getServer(String name) {
        for (ServerInfo server : BungeeCord.getInstance().getServers().values()) {
            if (!server.getName().equals(name)) continue;
            return server;
        }
        return null;
    }

    public static String cc(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

