/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass;

import com.gmail.thelimeglass.BungeeEventPacket;
import com.gmail.thelimeglass.BungeeEventPacketType;
import com.gmail.thelimeglass.BungeeEventRunner;
import com.gmail.thelimeglass.ConnectedServer;
import com.gmail.thelimeglass.ServerTracker;
import com.gmail.thelimeglass.SkellettPacket;
import com.gmail.thelimeglass.SkellettProxy;
import com.gmail.thelimeglass.VariableStorage;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class PacketHandler {
    public static Object handlePacket(SkellettPacket packet, InetAddress address) {
        SkellettProxy.debugMessage("Recieved packet: " + (Object)((Object)packet.getType()) + " with data: " + packet.getObject());
        ProxiedPlayer player = null;
        if (!(packet.getObject() instanceof ArrayList)) {
            if (packet.getObject() instanceof UUID) {
                player = BungeeCord.getInstance().getPlayer((UUID)packet.getObject());
            } else if (packet.getObject() instanceof String) {
                player = BungeeCord.getInstance().getPlayer((String)packet.getObject());
            }
        } else {
            ArrayList data = (ArrayList)packet.getObject();
            if (data.get(0) instanceof UUID) {
                player = BungeeCord.getInstance().getPlayer((UUID)data.get(0));
            } else if (data.get(0) instanceof String) {
                player = BungeeCord.getInstance().getPlayer((String)data.get(0));
            }
        }
        Map servers = BungeeCord.getInstance().getServers();
        switch (packet.getType()) {
            case PING: {
                ArrayList data = (ArrayList)packet.getObject();
                Boolean usingEvents = (Boolean)data.get(0);
                Integer eventPort = (Integer)data.get(1);
                Integer port = (Integer)data.get(2);
                ArrayList whitelisted = (ArrayList)data.get(3);
                Integer heartbeat = (Integer)data.get(4);
                String motd = (String)data.get(5);
                Integer max = (Integer)data.get(6);
                for (Map.Entry s : servers.entrySet()) {
                    ConnectedServer server;
                    if (!((ServerInfo)s.getValue()).getAddress().equals(new InetSocketAddress(address, (int)port)) || ServerTracker.contains(server = new ConnectedServer(usingEvents, eventPort, port, address, heartbeat, (String)s.getKey(), motd, max, whitelisted)).booleanValue()) continue;
                    ServerTracker.add(server);
                    return "CONNECTED";
                }
            }
            case ISPLAYERONLINE: {
                if (player != null) {
                    return true;
                }
                return false;
            }
            case ISUSINGFORGE: {
                if (player == null) break;
                return player.isForgeUser();
            }
            case ACTIONBAR: {
                if (player == null) break;
                ArrayList actionbarData = (ArrayList)packet.getObject();
                player.sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent((String)actionbarData.get(1)));
                break;
            }
            case PLAYERCHAT: {
                if (player == null) break;
                ArrayList chatData = (ArrayList)packet.getObject();
                player.chat((String)chatData.get(1));
                break;
            }
            case KICKPLAYERS: {
                for (ProxiedPlayer p : BungeeCord.getInstance().getPlayers()) {
                    p.disconnect((BaseComponent)new TextComponent((String)packet.getObject()));
                }
                break;
            }
            case KICKPLAYER: {
                if (player == null) break;
                ArrayList kickData = (ArrayList)packet.getObject();
                player.disconnect((BaseComponent)new TextComponent((String)kickData.get(1)));
                break;
            }
            case MESSAGEPLAYERS: {
                for (ProxiedPlayer p : BungeeCord.getInstance().getPlayers()) {
                    p.sendMessage((BaseComponent)new TextComponent((String)packet.getObject()));
                }
                break;
            }
            case MESSAGEPLAYER: {
                if (player == null) break;
                ArrayList messageData = (ArrayList)packet.getObject();
                player.sendMessage((BaseComponent)new TextComponent((String)messageData.get(1)));
                break;
            }
            case CONNECTPLAYER: {
                if (player == null) break;
                ArrayList connectData = (ArrayList)packet.getObject();
                ServerInfo serverinfo = BungeeCord.getInstance().getServerInfo((String)connectData.get(1));
                player.connect(serverinfo);
                break;
            }
            case BUNGEECOMMAND: {
                BungeeCord.getInstance().getPluginManager().dispatchCommand(BungeeCord.getInstance().getConsole(), (String)packet.getObject());
                break;
            }
            case PROXYSTOP: {
                if (packet.getObject() != null) {
                    BungeeCord.getInstance().stop((String)packet.getObject());
                    break;
                }
                BungeeCord.getInstance().stop();
                break;
            }
            case BUNGEEVERSION: {
                return BungeeCord.getInstance().getVersion();
            }
            case GLOBALPLAYERS: {
                ArrayList<String> globalPlayers = new ArrayList<String>();
                for (ProxiedPlayer p : BungeeCord.getInstance().getPlayers()) {
                    globalPlayers.add(p.getUniqueId().toString());
                }
                return globalPlayers;
            }
            case SERVERPLAYERS: {
                if (BungeeCord.getInstance().getServerInfo((String)packet.getObject()) == null) break;
                ArrayList<String> serverPlayers = new ArrayList<String>();
                for (ProxiedPlayer p : BungeeCord.getInstance().getServerInfo((String)packet.getObject()).getPlayers()) {
                    serverPlayers.add(p.getUniqueId().toString());
                }
                return serverPlayers;
            }
            case ALLSERVERS: {
                ArrayList<String> allservers = new ArrayList<String>();
                for (Map.Entry entry : BungeeCord.getInstance().getServers().entrySet()) {
                    allservers.add((String)entry.getKey());
                }
                return allservers;
            }
            case PLAYERIP: {
                if (player == null) break;
                return player.getAddress();
            }
            case PLAYERNAME: {
                if (player == null) break;
                return player.getName();
            }
            case PLAYERSERVER: {
                if (player.getServer() == null) break;
                SkellettProxy.debugMessage("TEST: " + player.getServer().getInfo().getName());
                return player.getServer().getInfo().getName();
            }
            case SERVERIP: {
                if (BungeeCord.getInstance().getServerInfo((String)packet.getObject()) == null) break;
                return BungeeCord.getInstance().getServerInfo((String)packet.getObject()).getAddress();
            }
            case SERVERMOTD: {
                if (BungeeCord.getInstance().getServerInfo((String)packet.getObject()) == null) break;
                return BungeeCord.getInstance().getServerInfo((String)packet.getObject()).getMotd();
            }
            case PLAYERUUID: {
                if (player == null) break;
                return player.getUniqueId().toString();
            }
            case PLAYERDISPLAYNAME: {
                if (player == null) break;
                if (packet.getSetObject() == null) {
                    return player.getDisplayName();
                }
                player.setDisplayName((String)packet.getSetObject());
                break;
            }
            case BUNGEEPLAYERLIMIT: {
                return BungeeCord.getInstance().getConfig().getPlayerLimit();
            }
            case PLAYERPING: {
                if (player == null) break;
                return player.getPing();
            }
            case HEARTBEAT: {
                Integer fromPort = (Integer)packet.getObject();
                if (fromPort == null) break;
                for (Map.Entry s : servers.entrySet()) {
                    if (!((ServerInfo)s.getValue()).getAddress().equals(new InetSocketAddress(address, (int)fromPort))) continue;
                    Boolean failed = ServerTracker.update((String)s.getKey());
                    SkellettProxy.globalScripts(ServerTracker.get((String)s.getKey()));
                    return failed;
                }
                break;
            }
            case MAXPLAYERS: {
                ConnectedServer servermax = ServerTracker.get((String)packet.getObject());
                if (servermax == null || !ServerTracker.isResponding(servermax).booleanValue()) break;
                SkellettProxy.debugMessage("Sending packet: " + (Object)((Object)packet.getType()) + " with data: " + servermax.getMaxPlayers());
                return servermax.getMaxPlayers();
            }
            case EVALUATE: {
                ArrayList evaluate = (ArrayList)packet.getObject();
                ConnectedServer evalServer = ServerTracker.get((String)evaluate.get(0));
                if (evalServer == null) break;
                BungeeEventPacket evalPacket = new BungeeEventPacket(false, evaluate.get(1), BungeeEventPacketType.EVALUATE);
                BungeeEventRunner.send(evalServer, evalPacket);
                break;
            }
            case ISSERVERONLINE: {
                ConnectedServer onlingServer = ServerTracker.get((String)packet.getObject());
                if (onlingServer != null) {
                    return true;
                }
                return false;
            }
            case WHITELISTED: {
                ConnectedServer whitelistedServer = ServerTracker.get((String)packet.getObject());
                if (whitelistedServer == null || !ServerTracker.isResponding(whitelistedServer).booleanValue()) break;
                return whitelistedServer.getWhitelistedPlayers();
            }
            case NETWORKVARIABLE: {
                String ID = (String)packet.getObject();
                if (ID != null) {
                    if (packet.getSetObject() == null) {
                        return VariableStorage.get(ID);
                    }
                    VariableStorage.write(ID, packet.getSetObject());
                }
                return null;
            }
        }
        return null;
    }
}

