/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.ClientBorders;

import com.gmail.thelimeglass.Skellett;
import com.gmail.thelimeglass.Utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ClientBorderManager {
    private static HashMap<Player, Double> WorldborderSize = new HashMap();
    private static HashMap<Player, Double> WorldborderDamageBuffer = new HashMap();
    private static HashMap<Player, Double> WorldborderDamage = new HashMap();
    private static HashMap<Player, Location> WorldborderCenter = new HashMap();
    private static HashMap<Player, Integer> WorldborderWarning = new HashMap();
    private static HashMap<Player, Integer> WorldborderWarningDistance = new HashMap();

    private static Boolean normal() {
        return Skellett.instance.getConfig().getBoolean("NormalBorders", false);
    }

    public static Object getWorldBorder(Player player, boolean createNew) {
        try {
            Object world;
            if (createNew) {
                return ReflectionUtil.getNMSClass("WorldBorder").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object nmsPlayer = ReflectionUtil.getHandle(player);
            if (Bukkit.getServer().getVersion().contains("MC: 1.8") || Bukkit.getServer().getVersion().contains("MC: 1.9") || Bukkit.getServer().getVersion().contains("MC: 1.10") || Bukkit.getServer().getVersion().contains("MC: 1.11")) {
                world = nmsPlayer.getClass().getField("world").get(nmsPlayer);
            } else {
                Class<?> serverClass = ReflectionUtil.getNMSClass("MinecraftServer");
                Class<?> entityClass = ReflectionUtil.getNMSClass("Entity");
                Field dimensionField = entityClass.getField("dimension");
                dimensionField.setAccessible(true);
                Integer dimension = dimensionField.getInt(nmsPlayer);
                world = serverClass.getMethod("getWorldServer", Integer.class).invoke(serverClass, dimension);
            }
            return world.getClass().getMethod("getWorldBorder", new Class[0]).invoke(world, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getBorderPacket(Player player, String borderAction, Object border) {
        try {
            Class<?> enumWorldBorderAction = ReflectionUtil.getNMSClass("PacketPlayOutWorldBorder$EnumWorldBorderAction");
            Object enumType = Enum.valueOf(enumWorldBorderAction, borderAction);
            Class<?> borderPacket = ReflectionUtil.getNMSClass("PacketPlayOutWorldBorder");
            Object packet = borderPacket.getConstructor(ReflectionUtil.getNMSClass("WorldBorder"), enumWorldBorderAction).newInstance(border, enumType);
            return packet;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setSize(Player player, Double size) {
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setSize", Double.TYPE);
            sizeMethod.invoke(border, size);
            Object packet = ClientBorderManager.getBorderPacket(player, "SET_SIZE", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderSize.containsKey(player)) {
                    WorldborderSize.remove(player);
                }
                WorldborderSize.put(player, size);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Double getSize(Player player) {
        return WorldborderSize.containsKey(player) ? WorldborderSize.get(player) : null;
    }

    public static void setCenter(Player player, Location location) {
        Double x = location.getX();
        Double z = location.getZ();
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setCenter", Double.TYPE, Double.TYPE);
            sizeMethod.invoke(border, x, z);
            Object packet = ClientBorderManager.getBorderPacket(player, "SET_CENTER", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderCenter.containsKey(player)) {
                    WorldborderCenter.remove(player);
                }
                WorldborderCenter.put(player, location);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Location getCenter(Player player) {
        return WorldborderCenter.containsKey(player) ? WorldborderCenter.get(player) : null;
    }

    public static void setDamageBuffer(Player player, Double value) {
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setDamageBuffer", Double.TYPE);
            sizeMethod.invoke(border, value);
            Object packet = ClientBorderManager.getBorderPacket(player, "INITIALIZE", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderDamageBuffer.containsKey(player)) {
                    WorldborderDamageBuffer.remove(player);
                }
                WorldborderDamageBuffer.put(player, value);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Double getDamageBuffer(Player player) {
        return WorldborderDamageBuffer.containsKey(player) ? WorldborderDamageBuffer.get(player) : null;
    }

    public static void setDamageAmount(Player player, Double value) {
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setDamageAmount", Double.TYPE);
            sizeMethod.invoke(border, value);
            Object packet = ClientBorderManager.getBorderPacket(player, "INITIALIZE", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderDamage.containsKey(player)) {
                    WorldborderDamage.remove(player);
                }
                WorldborderDamage.put(player, value);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Double getDamageAmount(Player player) {
        return WorldborderDamage.containsKey(player) ? WorldborderDamage.get(player) : null;
    }

    public static void setWarningTime(Player player, Integer value) {
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setWarningTime", Integer.TYPE);
            sizeMethod.invoke(border, value);
            Object packet = ClientBorderManager.getBorderPacket(player, "SET_WARNING_TIME", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderWarning.containsKey(player)) {
                    WorldborderWarning.remove(player);
                }
                WorldborderWarning.put(player, value);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Integer getWarningTime(Player player) {
        return WorldborderWarning.containsKey(player) ? WorldborderWarning.get(player) : null;
    }

    public static void setWarningDistance(Player player, Integer value) {
        try {
            Object border = ClientBorderManager.getWorldBorder(player, ClientBorderManager.normal() == false);
            Method sizeMethod = ReflectionUtil.getNMSClass("WorldBorder").getMethod("setWarningDistance", Integer.TYPE);
            sizeMethod.invoke(border, value);
            Object packet = ClientBorderManager.getBorderPacket(player, "SET_WARNING_BLOCKS", border);
            ReflectionUtil.sendPacket(player, packet);
            if (Skellett.instance.getConfig().getBoolean("ClientWorldBordersSave", true)) {
                if (WorldborderWarningDistance.containsKey(player)) {
                    WorldborderWarningDistance.remove(player);
                }
                WorldborderWarningDistance.put(player, value);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Integer getWarningDistance(Player player) {
        return WorldborderWarningDistance.containsKey(player) ? WorldborderWarningDistance.get(player) : null;
    }
}

