/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.PlayerPoints;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.thelimeglass.Skellett;
import com.gmail.thelimeglass.Utils.Annotations.Config;
import com.gmail.thelimeglass.Utils.Annotations.FullConfig;
import com.gmail.thelimeglass.Utils.Annotations.MainConfig;
import com.gmail.thelimeglass.Utils.Annotations.PropertyType;
import com.gmail.thelimeglass.Utils.Annotations.Syntax;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Syntax(value={"[the] [player[ ]]points of [(player|uuid)] %string%", "[(player|uuid)] %string%'s [player[ ]]points"})
@Config(value="PluginHooks.PlayerPoints")
@FullConfig
@MainConfig
@PropertyType(value=ExpressionType.COMBINED)
public class ExprPlayerPoints
extends SimpleExpression<Number> {
    private Expression<String> player;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "[the] [player[ ]]points of [(player|uuid)] %string%";
    }

    @Nullable
    protected Number[] get(Event e) {
        UUID uniqueId = null;
        try {
            uniqueId = UUID.fromString((String)this.player.getSingle(e));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (uniqueId != null) {
            return new Number[]{Skellett.playerPoints.getAPI().look(uniqueId)};
        }
        return new Number[]{Skellett.playerPoints.getAPI().look((String)this.player.getSingle(e))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        UUID uniqueId = null;
        try {
            uniqueId = UUID.fromString((String)this.player.getSingle(e));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Number amount = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            if (uniqueId != null) {
                Skellett.playerPoints.getAPI().set(uniqueId, amount.intValue());
            } else {
                Skellett.playerPoints.getAPI().set((String)this.player.getSingle(e), amount.intValue());
            }
        } else if (mode == Changer.ChangeMode.ADD) {
            if (uniqueId != null) {
                Skellett.playerPoints.getAPI().give(uniqueId, amount.intValue());
            } else {
                Skellett.playerPoints.getAPI().give((String)this.player.getSingle(e), amount.intValue());
            }
        } else if (mode == Changer.ChangeMode.REMOVE) {
            if (uniqueId != null) {
                Skellett.playerPoints.getAPI().take(uniqueId, amount.intValue());
            } else {
                Skellett.playerPoints.getAPI().take((String)this.player.getSingle(e), amount.intValue());
            }
        } else if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            if (uniqueId != null) {
                Skellett.playerPoints.getAPI().reset(uniqueId);
            } else {
                Skellett.playerPoints.getAPI().reset((String)this.player.getSingle(e), 0);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

