/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.WorldEdit;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.thelimeglass.Utils.Annotations.AntiDependency;
import com.gmail.thelimeglass.Utils.Annotations.Config;
import com.gmail.thelimeglass.Utils.Annotations.FullConfig;
import com.gmail.thelimeglass.Utils.Annotations.MainConfig;
import com.gmail.thelimeglass.Utils.Annotations.Syntax;
import com.gmail.thelimeglass.WorldEdit.WorldEditUtils;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Syntax(value={"(place|paste) schematic %string% at %locations% [[(with|at)] angle %-number%] [with limit %-number%] [[and] (without|exclud(e|ing)) air %-boolean%]"})
@Config(value="PluginHooks.Worldedit")
@AntiDependency(value={"PirateSK", "SharpSK"})
@FullConfig
@MainConfig
public class EffPasteSchematic
extends Effect {
    private Expression<String> name;
    private Expression<Location> locations;
    private Expression<Number> limit;
    private Expression<Number> angle;
    private static Expression<Boolean> air;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.name = e[0];
        this.locations = e[1];
        this.angle = e[2];
        this.limit = e[3];
        air = e[4];
        return true;
    }

    public String toString(@Nullable Event e, boolean paramBoolean) {
        return String.valueOf((String)this.name.getSingle(e)) + " at " + this.locations.getAll(e) + " & (place|paste) schematic %string% at %locations% [[(with|at)] angle %-number%] [with limit %-number%] [[and] (without|exclud(e|ing)) air %-boolean%]";
    }

    protected void execute(Event e) {
        if (this.name == null || this.locations == null) {
            return;
        }
        File file = ((String)this.name.getSingle(e)).contains("/") ? new File((String.valueOf((String)this.name.getSingle(e)) + ".schematic").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/schematics/" + (((String)this.name.getSingle(e)).contains(".") ? (String)this.name.getSingle(e) : String.valueOf(this.name.getSingle(e)) + ".schematic")).replaceAll("/", Matcher.quoteReplacement(File.separator)));
        if (!file.exists() || file.isDirectory() || file == null) {
            return;
        }
        Location[] locationArray = (Location[])this.locations.getAll(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer rotation;
            Location location = locationArray[n2];
            Integer maxLimit = this.limit == null ? 400000 : ((Number)this.limit.getSingle(e)).intValue();
            World world = WorldEditUtils.getWorld(location.getWorld().getName());
            EditSession session = WorldEdit.getInstance().getEditSessionFactory().getEditSession(world, maxLimit.intValue());
            Vector vector = new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Boolean noAir = air != null ? (Boolean)air.getSingle(e) : false;
            Integer n3 = rotation = this.angle != null ? Integer.valueOf(((Number)this.angle.getSingle(e)).intValue()) : null;
            if (session != null) {
                EffPasteSchematic.pasteOld(session, vector, file, noAir, rotation);
            }
            ++n2;
        }
    }

    private static void pasteOld(EditSession session, Vector vector, File file, Boolean air, @Nullable Integer rotation) {
        try {
            CuboidClipboard clipboard = SchematicFormat.getFormat((File)file).load(file);
            if (rotation != null) {
                clipboard.rotate2D(rotation.intValue());
            }
            clipboard.paste(session, vector, air.booleanValue());
            session.flushQueue();
        }
        catch (MaxChangedBlocksException | DataException | IOException error) {
            error.printStackTrace();
        }
    }

    private static void pasteFawe(World world, Vector vector, File file, Boolean air, @Nullable Integer rotation) {
        try {
            EditSession editSession = ClipboardFormat.SCHEMATIC.load(file).paste(world, vector, true, air.booleanValue(), null);
            editSession.flushQueue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

