/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.Expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.thelimeglass.Utils.Annotations.Config;
import com.gmail.thelimeglass.Utils.Annotations.PropertyType;
import com.gmail.thelimeglass.Utils.Annotations.Syntax;
import com.gmail.thelimeglass.Utils.Utils;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Syntax(value={"[the] stat[istic][s] %string% (of|from) %player% [[(with|from|for|of)] entity[[ ]type] %-string%] [[(with|from|for|of)] material %-string%]"})
@Config(value="Statistics")
@PropertyType(value=ExpressionType.COMBINED)
public class ExprStatistics
extends SimpleExpression<Number> {
    private Expression<String> statistic;
    private Expression<String> entity;
    private Expression<String> material;
    private Expression<Player> player;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.statistic = e[0];
        this.player = e[1];
        this.entity = e[2];
        this.material = e[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[the] stat[istic][s] %string% (of|from) %player% [[(with|from|for|of)] entity[[ ]type] %-string%] [[(with|from|for|of)] material %-string%]";
    }

    @Nullable
    protected Number[] get(Event e) {
        Statistic stat = (Statistic)Utils.getEnum(Statistic.class, (String)this.statistic.getSingle(e));
        if (this.entity != null) {
            EntityType type = (EntityType)Utils.getEnum(EntityType.class, (String)this.entity.getSingle(e));
            return new Number[]{((Player)this.player.getSingle(e)).getStatistic(stat, type)};
        }
        if (this.material != null) {
            Material m = (Material)Utils.getEnum(Material.class, (String)this.material.getSingle(e));
            return new Number[]{((Player)this.player.getSingle(e)).getStatistic(stat, m)};
        }
        return new Number[]{((Player)this.player.getSingle(e)).getStatistic(stat)};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Integer statNow = Arrays.asList(this.get(e)).get(0).intValue();
        if (mode == Changer.ChangeMode.SET) {
            Integer stat = ((Number)delta[0]).intValue();
            if (this.entity != null) {
                this.setEntity((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.entity.getSingle(e), stat);
            } else if (this.material != null) {
                this.setMaterial((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.material.getSingle(e), stat);
            } else {
                this.set((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), stat);
            }
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Integer stat = ((Number)delta[0]).intValue();
            if (this.entity != null) {
                this.setEntity((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.entity.getSingle(e), statNow - stat);
            } else if (this.material != null) {
                this.setMaterial((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.material.getSingle(e), statNow - stat);
            } else {
                this.set((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), statNow - stat);
            }
        } else if (mode == Changer.ChangeMode.ADD) {
            Integer stat = ((Number)delta[0]).intValue();
            if (this.entity != null) {
                this.setEntity((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.entity.getSingle(e), statNow + stat);
            } else if (this.material != null) {
                this.setMaterial((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), (String)this.material.getSingle(e), statNow + stat);
            } else {
                this.set((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), statNow + stat);
            }
        } else if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE_ALL) {
            this.set((String)this.statistic.getSingle(e), (Player)this.player.getSingle(e), 0);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    private void set(String statistic, Player player, Integer value) {
        Statistic stat = (Statistic)Utils.getEnum(Statistic.class, statistic);
        player.setStatistic(stat, value.intValue());
    }

    private void setEntity(String statistic, Player player, String entity, Integer value) {
        Statistic stat = (Statistic)Utils.getEnum(Statistic.class, statistic);
        if (entity != null) {
            EntityType type = (EntityType)Utils.getEnum(EntityType.class, entity);
            player.setStatistic(stat, type, value.intValue());
        }
    }

    private void setMaterial(String statistic, Player player, String material, Integer value) {
        Statistic stat = (Statistic)Utils.getEnum(Statistic.class, statistic);
        if (material != null) {
            Material m = (Material)Utils.getEnum(Material.class, material);
            player.setStatistic(stat, m, value.intValue());
        }
        player.setStatistic(stat, value.intValue());
    }
}

