/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.Regenerator;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.gmail.thelimeglass.Regenerator.Regenerator;
import com.gmail.thelimeglass.Skellett;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.material.MaterialData;

public class RegeneratorManager {
    private static final HashMap<String, Regenerator> regenerators = new HashMap();

    public static void addRegenerator(String ID, final @Nullable Location pos1, final @Nullable Location pos2) {
        if (!regenerators.containsKey(ID)) {
            if (pos1 == null || pos2 == null) {
                return;
            }
            final HashMap<Location, MaterialData> hashy = new HashMap<Location, MaterialData>();
            if (Skellett.instance.getConfig().getBoolean("Async", false)) {
                TaskManager.IMP.async(new Runnable(){

                    @Override
                    public void run() {
                        Location[] locationArray = RegeneratorManager.cuboid(pos1, pos2);
                        int n = locationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Location loc = locationArray[n2];
                            hashy.put(loc, loc.getBlock().getState().getData());
                            ++n2;
                        }
                    }
                });
            } else {
                Location[] locationArray = RegeneratorManager.cuboid(pos1, pos2);
                int n = locationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Location loc = locationArray[n2];
                    hashy.put(loc, loc.getBlock().getState().getData());
                    ++n2;
                }
            }
            regenerators.put(ID, new Regenerator(pos1, pos2, ID, hashy));
        }
    }

    public static void addRegenerator(String ID, final @Nullable Block[] blocks) {
        if (!regenerators.containsKey(ID)) {
            if (blocks == null) {
                return;
            }
            final HashMap<Location, MaterialData> hashy = new HashMap<Location, MaterialData>();
            if (Skellett.instance.getConfig().getBoolean("Async", false)) {
                TaskManager.IMP.async(new Runnable(){

                    @Override
                    public void run() {
                        Block[] blockArray = blocks;
                        int n = blocks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Block block = blockArray[n2];
                            hashy.put(block.getLocation(), block.getState().getData());
                            ++n2;
                        }
                    }
                });
            } else {
                Block[] blockArray = blocks;
                int n = blocks.length;
                int n2 = 0;
                while (n2 < n) {
                    Block block = blockArray[n2];
                    hashy.put(block.getLocation(), block.getState().getData());
                    ++n2;
                }
            }
            regenerators.put(ID, new Regenerator(null, null, ID, hashy));
        }
    }

    public static void reconfigure(String ID, Location pos1, Location pos2) {
        if (regenerators.containsKey(ID)) {
            RegeneratorManager.removeRegenerator(ID, false);
        }
        HashMap<Location, MaterialData> hashy = new HashMap<Location, MaterialData>();
        Location[] locationArray = RegeneratorManager.cuboid(pos1, pos2);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            hashy.put(loc, loc.getBlock().getState().getData());
            ++n2;
        }
        regenerators.put(ID, new Regenerator(pos1, pos2, ID, hashy));
    }

    public static void removeRegenerator(String ID, Boolean regenerate) {
        if (regenerators.containsKey(ID)) {
            if (regenerate.booleanValue()) {
                RegeneratorManager.regenerate(ID);
            }
            regenerators.remove(ID);
        }
    }

    public static void regenerate(String ID) {
        if (regenerators.containsKey(ID)) {
            HashMap<Location, MaterialData> hashy = regenerators.get(ID).getHashmap();
            if (Skellett.instance.getConfig().getBoolean("Async", false)) {
                ArrayList<Location> locs = new ArrayList<Location>(hashy.keySet());
                String world = ((Location)locs.get(0)).getWorld().getName();
                EditSession editSession = new EditSessionBuilder(FaweAPI.getWorld((String)world)).autoQueue(Boolean.valueOf(Skellett.instance.getConfig().getBoolean("RegeneratorAutoQueue", false))).fastmode(Boolean.valueOf(true)).build();
                for (Location loc : hashy.keySet()) {
                    if (loc.getBlock().getType() == hashy.get(loc).getItemType() || !Skellett.instance.getConfig().getBoolean("Async", false)) continue;
                    MaterialData data = hashy.get(loc);
                    BaseBlock block = new BaseBlock(data.getItemTypeId(), (int)data.getData());
                    try {
                        editSession.setBlock(new Vector(loc.getX(), loc.getY(), loc.getZ()), block);
                    }
                    catch (WorldEditException e) {
                        e.printStackTrace();
                    }
                }
                editSession.flushQueue();
            } else {
                int i = 0;
                while (i < 2) {
                    for (Location loc : hashy.keySet()) {
                        if (loc.getBlock().getType() == hashy.get(loc).getItemType()) continue;
                        try {
                            loc.getBlock().setType(hashy.get(loc).getItemType());
                            BlockState state = loc.getBlock().getState();
                            state.setData(hashy.get(loc));
                            state.update(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static Location getPos1(String ID) {
        if (regenerators.containsKey(ID)) {
            return regenerators.get(ID).getPos1();
        }
        return null;
    }

    public static Location getPos2(String ID) {
        if (regenerators.containsKey(ID)) {
            return regenerators.get(ID).getPos2();
        }
        return null;
    }

    public static boolean contains(String ID) {
        return regenerators.containsKey(ID);
    }

    public static String[] getAll() {
        return regenerators.keySet().toArray(new String[regenerators.keySet().size()]);
    }

    public static Regenerator get(String ID) {
        return regenerators.get(ID);
    }

    public static HashMap<String, Regenerator> getHashmap() {
        return regenerators;
    }

    public static Location[] cuboid(Location pos1, Location pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        int topX = pos1.getBlockX() < pos2.getBlockX() ? pos2.getBlockX() : pos1.getBlockX();
        int topY = pos1.getBlockY() < pos2.getBlockY() ? pos2.getBlockY() : pos1.getBlockY();
        int topZ = pos1.getBlockZ() < pos2.getBlockZ() ? pos2.getBlockZ() : pos1.getBlockZ();
        int bottomX = pos1.getBlockX() > pos2.getBlockX() ? pos2.getBlockX() : pos1.getBlockX();
        int bottomY = pos1.getBlockY() > pos2.getBlockY() ? pos2.getBlockY() : pos1.getBlockY();
        int bottomZ = pos1.getBlockZ() > pos2.getBlockZ() ? pos2.getBlockZ() : pos1.getBlockZ();
        int x = bottomX;
        while (x <= topX) {
            int z = bottomZ;
            while (z <= topZ) {
                int y = bottomY;
                while (y <= topY) {
                    locations.add(new Location(pos1.getWorld(), (double)x, (double)y, (double)z));
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return locations.toArray(new Location[locations.size()]);
    }
}

