/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.Books;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.thelimeglass.Utils.Annotations.Config;
import com.gmail.thelimeglass.Utils.Annotations.FullConfig;
import com.gmail.thelimeglass.Utils.Annotations.PropertyType;
import com.gmail.thelimeglass.Utils.Annotations.Syntax;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Syntax(value={"[the] [book['s]] page %number% (of|in) [book] %itemstack%", "%itemstack%'s [book] page %number%"})
@Config(value="Main.Books")
@FullConfig
@PropertyType(value=ExpressionType.COMBINED)
public class ExprBookPage
extends SimpleExpression<String> {
    private Expression<Number> page;
    private Expression<ItemStack> item;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.page = e[0];
            this.item = e[1];
        } else {
            this.item = e[0];
            this.page = e[1];
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "[the] [book['s]] page %number% (of|in) %itemstack%";
    }

    @Nullable
    protected String[] get(Event e) {
        BookMeta book = (BookMeta)((ItemStack)this.item.getSingle(e)).getItemMeta();
        Number num = (Number)this.page.getSingle(e);
        return new String[]{book.getPage(num.intValue())};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        BookMeta book = (BookMeta)((ItemStack)this.item.getSingle(e)).getItemMeta();
        Number num = (Number)this.page.getSingle(e);
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD) {
            book.setPage(num.intValue(), (String)delta[0]);
            ((ItemStack)this.item.getSingle(e)).setItemMeta((ItemMeta)book);
        } else if (mode == Changer.ChangeMode.DELETE) {
            List pages = book.getPages();
            pages.remove(num.intValue());
            book.setPages(pages);
            ((ItemStack)this.item.getSingle(e)).setItemMeta((ItemMeta)book);
        } else if (mode == Changer.ChangeMode.RESET) {
            List pages = book.getPages();
            pages.set(num.intValue(), "");
            book.setPages(pages);
            ((ItemStack)this.item.getSingle(e)).setItemMeta((ItemMeta)book);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

