/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.Expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.thelimeglass.Utils.Config;
import com.gmail.thelimeglass.Utils.FullConfig;
import com.gmail.thelimeglass.Utils.PropertyType;
import com.gmail.thelimeglass.Utils.Syntax;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;

@Syntax(value={"delay (of|from) spawner [at] %block%", "%block%'s spawn[er] delay", "spawn[er] delay (of|from) %block%"})
@Config(value="Main.Spawners")
@FullConfig
@PropertyType(value=ExpressionType.COMBINED)
public class ExprSpawnerDelay
extends SimpleExpression<Number> {
    private Expression<Block> spawner;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.spawner = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "delay of spawner %block%";
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.spawner != null) {
            return new Number[]{((CreatureSpawner)((Block)this.spawner.getSingle(e)).getState()).getDelay()};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.spawner != null) {
            Number delay = (Number)delta[0];
            Integer delayNow = ((CreatureSpawner)((Block)this.spawner.getSingle(e)).getState()).getDelay();
            CreatureSpawner spawn = (CreatureSpawner)((Block)this.spawner.getSingle(e)).getState();
            if (mode == Changer.ChangeMode.SET) {
                spawn.setDelay(delay.intValue());
            } else if (mode == Changer.ChangeMode.ADD) {
                spawn.setDelay(delayNow + delay.intValue());
            } else if (mode == Changer.ChangeMode.REMOVE) {
                spawn.setDelay(delayNow - delay.intValue());
            }
            spawn.update();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

