/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass;

import com.gmail.thelimeglass.Skellett;
import com.gmail.thelimeglass.SkellettPacket;
import com.gmail.thelimeglass.SkellettPacketType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Sockets {
    private static Socket client;
    private static Integer task;

    public static void run() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skellett.instance, new Runnable(){

            @Override
            public void run() {
                Sockets.connect();
                Sockets.heartbeat();
            }
        }, 1L);
    }

    public static void connect() {
        if (Sockets.isOpen().booleanValue()) {
            try {
                client = new Socket(Skellett.spData.getString("Host"), Skellett.spData.getInt("Port"));
                ObjectOutputStream objOUT = new ObjectOutputStream(client.getOutputStream());
                ObjectInputStream objIN = new ObjectInputStream(client.getInputStream());
                if (Skellett.spData.get("Heartbeat") == null) {
                    Skellett.spData.set("Heartbeat", (Object)50);
                    try {
                        Skellett.spData.save(Skellett.spFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<Serializable> data = new ArrayList<Serializable>(Arrays.asList(Bukkit.getPort(), Bukkit.getServerName(), Skellett.spData.getInt("Heartbeat", 50) * 60, Bukkit.getMotd(), Bukkit.getMaxPlayers()));
                SkellettPacket packet = new SkellettPacket(true, data, SkellettPacketType.PING);
                objOUT.writeObject(packet);
                Object answer = objIN.readObject();
                if (answer != null) {
                    Bukkit.getConsoleSender().sendMessage(Skellett.cc(String.valueOf(Skellett.prefix) + "Connected to SkellettProxy!"));
                }
                objOUT.close();
                objIN.close();
                client.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(Skellett.cc(String.valueOf(Skellett.prefix) + "&cIncorrect SkellettProxy details, No socket found or was denied access. For socket at " + Skellett.spData.getString("Host") + ":" + Skellett.spData.getInt("Port")));
        }
    }

    public static Object send(SkellettPacket packet) {
        Object answer = null;
        try {
            client = new Socket(Skellett.spData.getString("Host"), Skellett.spData.getInt("Port"));
            ObjectOutputStream objOUT = new ObjectOutputStream(client.getOutputStream());
            ObjectInputStream objIN = new ObjectInputStream(client.getInputStream());
            objOUT.writeObject(packet);
            if (packet.isReturnable().booleanValue()) {
                answer = objIN.readObject();
            }
            objOUT.close();
            objIN.close();
            client.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return answer;
    }

    public static void heartbeat() {
        task = Bukkit.getScheduler().scheduleAsyncRepeatingTask(Skellett.plugin, new Runnable(){

            @Override
            public void run() {
                if (!Sockets.isOpen().booleanValue()) {
                    if (Skellett.spData.getBoolean("Disconnect")) {
                        Sockets.stop();
                    }
                } else {
                    SkellettPacket packet = new SkellettPacket(false, Bukkit.getServerName(), SkellettPacketType.HEARTBEAT);
                    Sockets.send(packet);
                }
            }
        }, 1L, (long)Skellett.spData.getInt("Heartbeat", 50));
    }

    public static void stop() {
        Bukkit.getScheduler().cancelTask(task.intValue());
        Bukkit.getConsoleSender().sendMessage(Skellett.cc(String.valueOf(Skellett.prefix) + "&cDisconnected from SkellettProxy!"));
    }

    public static Boolean isOpen() {
        Boolean result = false;
        try {
            Socket attempt = new Socket();
            attempt.connect(new InetSocketAddress(Skellett.spData.getString("Host"), Skellett.spData.getInt("Port")));
            attempt.close();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

