/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.SkellettAPI;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BlockConstructor {
    List<BlockLayer> layers = new ArrayList<BlockLayer>();
    private int i = 0;

    public BlockConstructor(BlockLayer ... layers) {
        BlockLayer[] blockLayerArray = layers;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            BlockLayer layer = blockLayerArray[n2];
            this.layers.add(layer);
            ++n2;
        }
    }

    public void addLayer(BlockLayer layer) {
        this.layers.add(layer);
    }

    public void generateWithTime(final Plugin plugin, final Location startLocation, Long timeInTicks, final boolean effect) {
        long ticks = (long)Math.ceil(timeInTicks / (long)this.layers.size());
        new BukkitRunnable(){

            public void run() {
                final BlockLayer layer = BlockConstructor.this.layers.get(BlockConstructor.this.i);
                final Location layerStart = startLocation.clone().add(0.0, (double)BlockConstructor.this.layers.indexOf(layer), 0.0);
                new BukkitRunnable(){

                    public void run() {
                        layer.generateLayer(layerStart, effect);
                    }
                }.runTask(plugin);
                BlockConstructor blockConstructor = BlockConstructor.this;
                blockConstructor.i = blockConstructor.i + 1;
                if (BlockConstructor.this.i == BlockConstructor.this.layers.size()) {
                    BlockConstructor.this.i = 0;
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(plugin, 1L, ticks);
    }

    public void generate(Location startLocation, boolean effect) {
        for (BlockLayer layer : this.layers) {
            Location layerStart = startLocation.clone().add(0.0, (double)this.layers.indexOf(layer), 0.0);
            layer.generateLayer(layerStart, effect);
        }
    }

    public static class BlockLayer {
        private String layer;
        private HashMap<Character, Material> chars = new HashMap();

        public BlockLayer(String layer) {
            this.layer = layer;
        }

        public BlockLayer setBlockType(char character, Material material) {
            this.chars.put(Character.valueOf(character), material);
            return this;
        }

        public void generateLayer(Location start, boolean effect) {
            int skip = 0;
            int rowZ = 0;
            int rowY = 0;
            int i = 0;
            while (i < this.layer.length()) {
                char character = this.layer.charAt(i);
                if (character == ':' || character == ',') {
                    ++rowY;
                    skip = i + 1;
                }
                if (character == ';' || character == '.') {
                    ++rowZ;
                    skip = i + 1;
                } else {
                    Block block = start.getWorld().getBlockAt(start.getBlockX() + i - skip, start.getBlockY() + rowY, start.getBlockZ() + rowZ);
                    if (this.chars.containsKey(Character.valueOf(character))) {
                        block.setType(this.chars.get(Character.valueOf(character)));
                        if (effect) {
                            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, block.getTypeId());
                        }
                    }
                }
                ++i;
            }
        }
    }
}

