/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skacket.managers;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.limeglass.skacket.Skacket;
import me.limeglass.skacket.wrappers.WrapperPlayServerOpenSignEntity;
import me.limeglass.skacket.wrappers.WrapperPlayServerUpdateSign;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;

public class SignManager
implements Listener {
    private final Set<SignEditor> signs = new HashSet<SignEditor>();

    public SignManager(Skacket instance) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)instance);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.getSignFor(player).ifPresent(sign -> {
            Set<Player> players = sign.getPlayers();
            players.remove(player);
            if (players.isEmpty()) {
                this.signs.remove(sign);
            }
        });
    }

    public SignEditor open(Event event, String[] text, Player ... players) {
        HashSet set = Sets.newHashSet((Object[])players);
        Iterator<SignEditor> iterator = this.signs.iterator();
        while (iterator.hasNext()) {
            iterator.next().getPlayers().removeAll(set);
        }
        SignEditor sign = new SignEditor(event, text, set);
        for (Player player : players) {
            Location location = player.getLocation();
            location.setY(255.0);
            sign.setPreviousBlockData(player, location.getBlock().getBlockData());
            player.sendBlockChange(location, this.materialAttempt("SIGN_POST", "OAK_SIGN").createBlockData());
            if (text != null && text.length <= 4 && text.length > 0) {
                WrapperPlayServerUpdateSign updateSignPacket = new WrapperPlayServerUpdateSign();
                updateSignPacket.setLocation(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
                updateSignPacket.setLines(Lists.newArrayList((Object[])text));
                updateSignPacket.sendPacket(player);
            }
            WrapperPlayServerOpenSignEntity packet = new WrapperPlayServerOpenSignEntity();
            packet.setLocation(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            packet.sendPacket(player);
        }
        this.signs.add(sign);
        return sign;
    }

    private Material materialAttempt(String attempt, String fallback) {
        Material material = null;
        try {
            material = Material.valueOf((String)attempt.toUpperCase());
        }
        catch (Exception e) {
            try {
                material = Material.valueOf((String)fallback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (material == null) {
            material = Material.CHEST;
        }
        return material;
    }

    public Optional<SignEditor> getSignFor(Player player) {
        return this.signs.stream().filter(sign -> sign.getPlayers().contains(player)).findFirst();
    }

    public Optional<SignEditor> getSignFor(Event event) {
        return this.signs.stream().filter(sign -> sign.getEvent().equals(event)).findFirst();
    }

    public Set<SignEditor> getSigns() {
        return this.signs;
    }

    public class SignEditor {
        private Map<Player, BlockData> previousBlockData = new HashMap<Player, BlockData>();
        private final Set<Player> players = new HashSet<Player>();
        private Consumer<SignChangeEvent> consumer;
        private final String[] lines;
        private final Event event;

        public SignEditor(Event event, String[] lines, Collection<Player> players) {
            this.players.addAll(players);
            this.lines = lines;
            this.event = event;
        }

        public SignEditor onUpdate(Consumer<SignChangeEvent> consumer) {
            this.consumer = consumer;
            return this;
        }

        public void setPreviousBlockData(Player player, BlockData data) {
            this.previousBlockData.put(player, data);
        }

        public Optional<BlockData> getPreviousBlockData(Player player) {
            return Optional.ofNullable(this.previousBlockData.get(player));
        }

        public void accept(SignChangeEvent event) {
            this.consumer.accept((Object)event);
            this.players.remove(event.getPlayer());
            if (this.players.isEmpty()) {
                SignManager.this.signs.remove(this);
            }
        }

        public Set<Player> getPlayers() {
            return this.players;
        }

        public String[] getLines() {
            return this.lines;
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

