/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skacket.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import java.util.Arrays;
import java.util.HashSet;
import me.limeglass.skacket.Skacket;
import me.limeglass.skacket.events.ServerSignChangeEvent;
import me.limeglass.skacket.events.SteerVehicleEvent;
import me.limeglass.skacket.wrappers.WrapperPlayClientUpdateSign;
import me.limeglass.skacket.wrappers.WrapperPlayServerUpdateSign;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

public class PacketListeners {
    static {
        final Skacket instance = Skacket.getInstance();
        instance.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)instance, new PacketType[]{PacketType.Play.Client.STEER_VEHICLE}){

            public void onPacketReceiving(PacketEvent event) {
                StructureModifier booleans;
                float forwards;
                PacketContainer packet = event.getPacket();
                HashSet<SteerVehicleEvent.Movement> movements = new HashSet<SteerVehicleEvent.Movement>();
                StructureModifier floats = packet.getFloat();
                float sideways = ((Float)floats.read(0)).floatValue();
                if (sideways != 0.0f) {
                    movements.add(sideways > 0.0f ? SteerVehicleEvent.Movement.LEFT : SteerVehicleEvent.Movement.RIGHT);
                }
                if ((forwards = ((Float)floats.read(1)).floatValue()) != 0.0f) {
                    movements.add(forwards > 0.0f ? SteerVehicleEvent.Movement.FORWARDS : SteerVehicleEvent.Movement.BACKWARDS);
                }
                if (((Boolean)(booleans = packet.getBooleans()).read(0)).booleanValue()) {
                    movements.add(SteerVehicleEvent.Movement.JUMP);
                }
                if (((Boolean)booleans.read(1)).booleanValue()) {
                    movements.add(SteerVehicleEvent.Movement.UNMOUNT);
                }
                if (movements.isEmpty()) {
                    return;
                }
                SteerVehicleEvent steer = new SteerVehicleEvent(event.getPlayer(), movements.toArray(new SteerVehicleEvent.Movement[movements.size()]));
                Bukkit.getPluginManager().callEvent((Event)steer);
                if (steer.isCancelled()) {
                    event.setCancelled(true);
                }
            }
        });
        instance.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)instance, new PacketType[]{PacketType.Play.Server.UPDATE_SIGN}){

            public void onPacketReceiving(PacketEvent event) {
                WrapperPlayServerUpdateSign packet = new WrapperPlayServerUpdateSign(event.getPacket());
                String[] lines = (String[])Arrays.stream(packet.getLines()).map(component -> component.toString()).toArray(String[]::new);
                Player player = event.getPlayer();
                BlockPosition position = packet.getLocation();
                if (position == null) {
                    return;
                }
                Location location = position.toLocation(player.getWorld());
                ServerSignChangeEvent signEvent = new ServerSignChangeEvent(location.getBlock(), event.getPlayer(), lines);
                Bukkit.getPluginManager().callEvent((Event)signEvent);
                if (event.isCancelled()) {
                    event.setCancelled(true);
                    return;
                }
            }
        });
        instance.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)instance, new PacketType[]{PacketType.Play.Client.UPDATE_SIGN}){

            public void onPacketReceiving(PacketEvent event) {
                WrapperPlayClientUpdateSign packet = new WrapperPlayClientUpdateSign(event.getPacket());
                String[] lines = packet.getLines();
                Player player = event.getPlayer();
                BlockPosition position = packet.getLocation();
                if (position == null) {
                    return;
                }
                Location location = position.toLocation(player.getWorld());
                instance.getSignManager().getSignFor(player).ifPresent(sign -> Bukkit.getScheduler().runTask((Plugin)instance, () -> {
                    SignChangeEvent signEvent = new SignChangeEvent(location.getBlock(), event.getPlayer(), lines);
                    if (instance.getConfig().getBoolean("signgui-call-change-event", false)) {
                        Bukkit.getPluginManager().callEvent((Event)signEvent);
                        if (event.isCancelled()) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                    sign.getPreviousBlockData(player).ifPresent(blockData -> player.sendBlockChange(location, blockData));
                    sign.accept(signEvent);
                }));
            }
        });
    }
}

