/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skacket.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.google.common.collect.Sets;
import java.util.HashSet;
import me.limeglass.skacket.wrappers.WrapperPlayServerBlockBreakAnimation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EffBlockBreakAnimation
extends Effect {
    private Expression<Location> locations;
    @Nullable
    private Expression<Player> players;
    private Expression<Number> stage;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.players = exprs[0];
            this.locations = exprs[1];
            this.stage = exprs[2];
        } else {
            this.stage = exprs[0];
            this.locations = exprs[1];
            this.players = exprs[2];
        }
        return true;
    }

    protected void execute(Event event) {
        HashSet receivers = new HashSet();
        if (this.players == null) {
            receivers.addAll(Bukkit.getOnlinePlayers());
        } else {
            receivers.addAll(Sets.newHashSet((Object[])this.players.getArray(event)));
        }
        int stage = ((Number)this.stage.getSingle(event)).intValue();
        for (Location location : (Location[])this.locations.getArray(event)) {
            for (Player receiver : receivers) {
                WrapperPlayServerBlockBreakAnimation packet = new WrapperPlayServerBlockBreakAnimation();
                packet.setLocation(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
                packet.setEntityID(receiver.getEntityId());
                packet.setDestroyStage(stage);
                packet.sendPacket(receiver);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (event == null) {
            return "block break animation";
        }
        return "block break animation to " + this.players.toString(event, debug) + " at stage " + this.stage.toString(event, debug) + " at " + this.locations.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffBlockBreakAnimation.class, (String[])new String[]{"show [%-players%] [a] block break animation at %locations% with stage %number%", "show [a] block break [animation] stage %number% at %locations% [for %-players%]", "show stacking block break [animation] stage %number% at %locations% [for %-players%]"});
    }
}

