/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.waze.data;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import fr.weefle.waze.Waze;
import fr.weefle.waze.data.PluginMessage;
import fr.weefle.waze.data.events.PluginMessageReceiveEvent;
import fr.weefle.waze.data.events.PluginMessageRequestReceiveEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitRunnable;

public class ComApiBukkitHandler
implements PluginMessageListener {
    private Waze instance;
    private List<String> uuids;
    private String channel;

    public ComApiBukkitHandler(Waze instance, String channel) {
        this.instance = instance;
        this.channel = channel;
        this.uuids = new ArrayList<String>();
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)instance, channel);
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)instance, channel, (PluginMessageListener)this);
    }

    public void sendMessage(PluginMessage pm) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(pm.encodeData());
        Bukkit.getServer().sendPluginMessage((Plugin)this.instance, this.channel, out.toByteArray());
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] content) {
        if (!channel.equalsIgnoreCase(channel)) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(content));
            final PluginMessage pm = new PluginMessage();
            pm.decodeData(in.readUTF());
            if (this.uuids.contains(pm.getUUID())) {
                return;
            }
            this.uuids.add(pm.getUUID());
            new BukkitRunnable(){

                public void run() {
                    ComApiBukkitHandler.this.uuids.remove(pm.getUUID());
                }
            }.runTaskLater((Plugin)this.instance, 60L);
            if (pm.requireResponse()) {
                PluginMessageRequestReceiveEvent event = new PluginMessageRequestReceiveEvent(this.instance, pm);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.getResponse() == null) {
                    Bukkit.getLogger().warning("No response set for message: " + pm.getUUID() + "-" + pm.getType());
                    return;
                }
                this.sendMessage(event.getResponse());
            } else {
                Bukkit.getPluginManager().callEvent((Event)new PluginMessageReceiveEvent(this.instance, pm));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("Failed to handle plugin message !");
        }
    }
}

