/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.waze;

import com.tjplaysnow.discord.object.Bot;
import fr.weefle.waze.discord.DiscordRegister;
import fr.weefle.waze.nms.ActionBarAPI;
import fr.weefle.waze.nms.ActionBarNew;
import fr.weefle.waze.nms.AutoRespawnAPI;
import fr.weefle.waze.nms.AutoRespawnNew;
import fr.weefle.waze.nms.BossBarAPI;
import fr.weefle.waze.nms.BossBarNew;
import fr.weefle.waze.nms.Nametag;
import fr.weefle.waze.nms.ParticleAPI;
import fr.weefle.waze.nms.ParticleNew;
import fr.weefle.waze.nms.Ping;
import fr.weefle.waze.nms.ScoreBoard;
import fr.weefle.waze.nms.Tablist;
import fr.weefle.waze.nms.Title;
import fr.weefle.waze.old.ActionBarOld;
import fr.weefle.waze.old.AutoRespawnOld;
import fr.weefle.waze.old.BossBarOld;
import fr.weefle.waze.old.ParticleOld;
import fr.weefle.waze.utils.Metrics;
import fr.weefle.waze.utils.Register;
import fr.weefle.waze.utils.Updater;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Waze
extends JavaPlugin {
    private static Waze instance;
    private ActionBarAPI actionbar;
    private Title title;
    private BossBarAPI bossbar;
    private Ping ping;
    private Tablist tablist;
    private ParticleAPI particle;
    private Nametag nametag;
    private ScoreBoard scoreboard;
    private AutoRespawnAPI autorespawn;
    private DiscordRegister discord;
    private Bot bot;

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("Discord-ProgramBot-API")) {
            this.discord = new DiscordRegister(this);
            this.bot = new Bot("NDYxNTk3MzYyODcyMTIzMzkz.DhVocQ.px7FnBq7Z8XJw9vW97H0hriGenI", "[Wazea]");
            this.discord.initialiseBot(this.bot);
            this.getLogger().info("Discord setup was successful!");
        } else {
            this.getLogger().severe("Failed to setup Discord!");
        }
        this.getLogger().info("SkWrapper setup was successful!");
        new Metrics(this);
        this.getLogger().info("Metrics setup was successful!");
        try {
            new Updater(this, 49195);
            this.getLogger().info("Updater setup was successful!");
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to setup Updater!");
            this.getLogger().severe("Verify the resource's link!");
            e.printStackTrace();
        }
        if (this.setupNMS()) {
            this.getLogger().info("NMS setup was successful!");
            this.getLogger().info("The plugin setup process is complete!");
        } else {
            this.getLogger().severe("Failed to setup NMS!");
            this.getLogger().severe("Your server version is not compatible with this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        instance = this;
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        new Register(this);
    }

    private boolean setupNMS() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return false;
        }
        this.getLogger().info("Your server is running version " + version);
        this.scoreboard = new ScoreBoard();
        this.ping = new Ping();
        this.nametag = new Nametag();
        this.tablist = new Tablist();
        if (version.equals("v1_8_R3") || version.equals("v1_8_R2") || version.equals("v1_8_R1")) {
            this.particle = new ParticleOld();
            this.title = new Title();
            this.autorespawn = new AutoRespawnOld(this);
            this.bossbar = new BossBarOld();
            this.actionbar = new ActionBarOld();
        } else if (version.equals("v1_7_R4") || version.equals("v1_7_R3") || version.equals("v1_7_R2") || version.equals("v1_7_R1")) {
            this.particle = new ParticleOld();
            this.autorespawn = new AutoRespawnOld(this);
            this.bossbar = new BossBarOld();
        } else if (version.equals("v1_9_R1") || version.equals("v1_9_R2")) {
            this.title = new Title();
            this.particle = new ParticleNew();
            this.autorespawn = new AutoRespawnNew();
            this.bossbar = new BossBarNew(this);
            this.actionbar = new ActionBarOld();
        } else {
            this.title = new Title();
            this.particle = new ParticleNew();
            this.autorespawn = new AutoRespawnNew();
            this.bossbar = new BossBarNew(this);
            this.actionbar = new ActionBarNew();
        }
        return true;
    }

    public ActionBarAPI getActionbar() {
        return this.actionbar;
    }

    public Title getTitle() {
        return this.title;
    }

    public static Waze getInstance() {
        return instance;
    }

    public BossBarAPI getBossBar() {
        return this.bossbar;
    }

    public Ping getPing() {
        return this.ping;
    }

    public ScoreBoard getScoreBoard() {
        return this.scoreboard;
    }

    public AutoRespawnAPI getAutoRespawn() {
        return this.autorespawn;
    }

    public Nametag getNametag() {
        return this.nametag;
    }

    public Tablist getTablist() {
        return this.tablist;
    }

    public ParticleAPI getParticles() {
        return this.particle;
    }

    public DiscordRegister getDiscord() {
        return this.discord;
    }
}

