/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.waze;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleEvent;
import fr.weefle.waze.effects.WazeEffectActionBar;
import fr.weefle.waze.effects.WazeEffectBossBarCreate;
import fr.weefle.waze.effects.WazeEffectBossBarRemove;
import fr.weefle.waze.effects.WazeEffectBossBarRemoveAll;
import fr.weefle.waze.effects.WazeEffectBossBarTime;
import fr.weefle.waze.effects.WazeEffectBungee;
import fr.weefle.waze.effects.WazeEffectClearRecipes;
import fr.weefle.waze.effects.WazeEffectParticles;
import fr.weefle.waze.effects.WazeEffectRecipe;
import fr.weefle.waze.effects.WazeEffectRemoveScoreBoard;
import fr.weefle.waze.effects.WazeEffectScoreBoard;
import fr.weefle.waze.effects.WazeEffectTitle;
import fr.weefle.waze.events.PlayerJumpEvent;
import fr.weefle.waze.expressions.WazeExpressionPing;
import fr.weefle.waze.nms.ActionBar;
import fr.weefle.waze.nms.BossBar;
import fr.weefle.waze.nms.Particles;
import fr.weefle.waze.nms.Ping;
import fr.weefle.waze.nms.ScoreBoard;
import fr.weefle.waze.nms.Title;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Waze
extends JavaPlugin {
    private static Waze instance;
    private ActionBar actionbar;
    private Title title;
    private BossBar bossbar;
    private Ping ping;
    private Particles particles;
    private ScoreBoard scoreboard;

    public void onEnable() {
        if (this.setupNMS()) {
            this.getLogger().info("NMS setup was successful!");
            this.getLogger().info("The plugin setup process is complete!");
        } else {
            this.getLogger().severe("Failed to setup NMS!");
            this.getLogger().severe("Your server version is not compatible with this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        instance = this;
        PlayerJumpEvent.register(this);
        Skript.registerAddon((JavaPlugin)this);
        Skript.registerEffect(WazeEffectTitle.class, (String[])new String[]{"[waze] (send|create) title %string% with [sub[title]] %string% (to|for) %player% (for|to) %integer% tick[s]"});
        Skript.registerEffect(WazeEffectActionBar.class, (String[])new String[]{"[waze] (send|create) action[bar] %string% (to|for) %player%"});
        Skript.registerEffect(WazeEffectBungee.class, (String[])new String[]{"[waze] (send|teleport) %player% to [bungee[cord]] server %string%"});
        Skript.registerExpression(WazeExpressionPing.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[waze] %player%['s] ping", "[waze] ping of %player%"});
        Skript.registerEffect(WazeEffectRecipe.class, (String[])new String[]{"[waze] (create|register) [new] recipe[s] [for] %itemtype% with %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%"});
        Skript.registerEffect(WazeEffectClearRecipes.class, (String[])new String[]{"[waze] (remove|clear|delete) [all] [craft[ing]] recipe[s]"});
        Skript.registerEffect(WazeEffectBossBarCreate.class, (String[])new String[]{"[waze] (create|send) [boss]bar %string% (with|at) %double% percent[s] (and|with) color %string% (to|for) %player%"});
        Skript.registerEffect(WazeEffectBossBarTime.class, (String[])new String[]{"[waze] (create|send) [boss]bar %string% (with|at) %double% percent[s] (and|with) color %string% (for|and) %integer% tick[s] (to|for) %player%"});
        Skript.registerEffect(WazeEffectBossBarRemove.class, (String[])new String[]{"[waze] (remove|delete|clear) [boss]bar (of|for) %player%"});
        Skript.registerEffect(WazeEffectScoreBoard.class, (String[])new String[]{"[waze] (create|make) scoreboard %string% of type %string% to [display]slot %string% (with|and) score %string% (at|for) line %integer% (to|for) %player%"});
        Skript.registerEffect(WazeEffectRemoveScoreBoard.class, (String[])new String[]{"[waze] (clear|remove) scoreboard %string% (of|for) %player%"});
        Skript.registerEffect(WazeEffectParticles.class, (String[])new String[]{"[waze] (spawn|create|summon) [a number of] %integer% [of] %string%['s] particle[s] (to|for) %player% (at|from) %location% (and|with) offset %float%, %float%, %float% (and|with) data %float%"});
        Skript.registerEffect(WazeEffectBossBarRemoveAll.class, (String[])new String[]{"[waze] (remove|delete|clear) all [boss]bar"});
        Skript.registerEvent((String)"Jump Event", SimpleEvent.class, PlayerJumpEvent.class, (String[])new String[]{"[waze] jump[ing]"});
    }

    private boolean setupNMS() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return false;
        }
        this.getLogger().info("Your server is running version " + version);
        this.title = new Title();
        this.scoreboard = new ScoreBoard();
        this.bossbar = new BossBar(this);
        this.actionbar = new ActionBar();
        this.ping = new Ping();
        this.particles = new Particles();
        return true;
    }

    public ActionBar getActionbar() {
        return this.actionbar;
    }

    public Title getTitle() {
        return this.title;
    }

    public static Waze getInstance() {
        return instance;
    }

    public BossBar getBossBar() {
        return this.bossbar;
    }

    public Ping getPing() {
        return this.ping;
    }

    public ScoreBoard getScoreBoard() {
        return this.scoreboard;
    }

    public Particles getParticles() {
        return this.particles;
    }
}

