/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.waze;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleEvent;
import fr.weefle.waze.effects.WazeEffectActionBar;
import fr.weefle.waze.effects.WazeEffectAutoRespawn;
import fr.weefle.waze.effects.WazeEffectBossBarCreate;
import fr.weefle.waze.effects.WazeEffectBossBarRemove;
import fr.weefle.waze.effects.WazeEffectBossBarTimer;
import fr.weefle.waze.effects.WazeEffectBungee;
import fr.weefle.waze.effects.WazeEffectClearRecipes;
import fr.weefle.waze.effects.WazeEffectParticles;
import fr.weefle.waze.effects.WazeEffectRecipe;
import fr.weefle.waze.effects.WazeEffectRemoveScoreBoard;
import fr.weefle.waze.effects.WazeEffectScoreBoard;
import fr.weefle.waze.effects.WazeEffectTitle;
import fr.weefle.waze.events.PlayerJumpEvent;
import fr.weefle.waze.expressions.WazeExpressionPing;
import fr.weefle.waze.nms.ActionBar;
import fr.weefle.waze.nms.ActionBarNew;
import fr.weefle.waze.nms.ActionBarOld;
import fr.weefle.waze.nms.AutoRespawn;
import fr.weefle.waze.nms.AutoRespawnNew;
import fr.weefle.waze.nms.AutoRespawnOld;
import fr.weefle.waze.nms.BossBarAPI;
import fr.weefle.waze.nms.BossBarNew;
import fr.weefle.waze.nms.BossBarOld;
import fr.weefle.waze.nms.Particles;
import fr.weefle.waze.nms.Ping;
import fr.weefle.waze.nms.ScoreBoard;
import fr.weefle.waze.nms.Title;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Waze
extends JavaPlugin {
    private static Waze instance;
    private ActionBar actionbar;
    private Title title;
    private BossBarAPI bossbar;
    private Ping ping;
    private Particles particles;
    private ScoreBoard scoreboard;
    private AutoRespawn autorespawn;

    public void onEnable() {
        if (this.setupNMS()) {
            this.getLogger().info("NMS setup was successful!");
            this.getLogger().info("The plugin setup process is complete!");
        } else {
            this.getLogger().severe("Failed to setup NMS!");
            this.getLogger().severe("Your server version is not compatible with this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        instance = this;
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        PlayerJumpEvent.register(this);
        Skript.registerAddon((JavaPlugin)this);
        Skript.registerEffect(WazeEffectTitle.class, (String[])new String[]{"[waze] (send|create) title %string% with [sub[title]] %string% (to|for) %players% (for|to) %integer% tick[s]"});
        Skript.registerEffect(WazeEffectActionBar.class, (String[])new String[]{"[waze] (send|create) action[bar] %string% (to|for) %players%"});
        Skript.registerEffect(WazeEffectBungee.class, (String[])new String[]{"[waze] (send|teleport) %players% to [bungee[cord]] server %string%"});
        Skript.registerExpression(WazeExpressionPing.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[waze] %players%['s] ping", "[waze] ping of %players%"});
        Skript.registerEffect(WazeEffectRecipe.class, (String[])new String[]{"[waze] (create|register) [new] recipe[s] [for] %itemtype% with %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%"});
        Skript.registerEffect(WazeEffectClearRecipes.class, (String[])new String[]{"[waze] (remove|clear|delete) [all] [craft[ing]] recipe[s]"});
        Skript.registerEffect(WazeEffectBossBarCreate.class, (String[])new String[]{"[waze] (create|send) [boss]bar %string% (with|at) %double% percent[s] (and|with) color %string% with id %string% (to|for) %player%"});
        Skript.registerEffect(WazeEffectBossBarTimer.class, (String[])new String[]{"[waze] (create|send) [boss]bar %string% (with|at) %double% percent[s] (and|with) color %string% with id %string% (for|and) %integer% tick[s] (to|for) %player%"});
        Skript.registerEffect(WazeEffectBossBarRemove.class, (String[])new String[]{"[waze] (remove|delete|clear) [boss]bar with id %string% (of|for) %player%"});
        Skript.registerEffect(WazeEffectScoreBoard.class, (String[])new String[]{"[waze] (create|make) scoreboard %string% of type %string% to [display]slot %string% (with|and) score %string% (at|for) line %integer% (to|for) %players%"});
        Skript.registerEffect(WazeEffectRemoveScoreBoard.class, (String[])new String[]{"[waze] (clear|remove) scoreboard %string% (of|for) %players%"});
        Skript.registerEffect(WazeEffectAutoRespawn.class, (String[])new String[]{"[waze] [auto]respawn %players%"});
        Skript.registerEffect(WazeEffectParticles.class, (String[])new String[]{"[waze] (spawn|create|summon) [a number of] %integer% [of] %string%['s] particle[s] (to|for) %players% (at|from) %locations% (and|with) offset %float%, %float%, %float% (and|with) data %float%"});
        Skript.registerEvent((String)"Jump Event", SimpleEvent.class, PlayerJumpEvent.class, (String[])new String[]{"[waze] jump[ing]"});
    }

    private boolean setupNMS() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return false;
        }
        this.getLogger().info("Your server is running version " + version);
        if (version.equals("v1_12_R1")) {
            this.title = new Title();
            this.autorespawn = new AutoRespawnNew();
            this.scoreboard = new ScoreBoard();
            this.bossbar = new BossBarNew(this);
            this.actionbar = new ActionBarNew();
            this.ping = new Ping();
            this.particles = new Particles();
        } else if (version.equals("v1_8_R3")) {
            this.title = new Title();
            this.scoreboard = new ScoreBoard();
            this.autorespawn = new AutoRespawnOld(this);
            this.bossbar = new BossBarOld();
            this.actionbar = new ActionBarOld();
            this.ping = new Ping();
            this.particles = new Particles();
        } else if (version.equals("v1_7_R4")) {
            this.scoreboard = new ScoreBoard();
            this.autorespawn = new AutoRespawnOld(this);
            this.ping = new Ping();
            this.bossbar = new BossBarOld();
            this.particles = new Particles();
        } else {
            this.title = new Title();
            this.autorespawn = new AutoRespawnNew();
            this.scoreboard = new ScoreBoard();
            this.bossbar = new BossBarNew(this);
            this.actionbar = new ActionBarOld();
            this.ping = new Ping();
            this.particles = new Particles();
        }
        return true;
    }

    public ActionBar getActionbar() {
        return this.actionbar;
    }

    public Title getTitle() {
        return this.title;
    }

    public static Waze getInstance() {
        return instance;
    }

    public BossBarAPI getBossBar() {
        return this.bossbar;
    }

    public Ping getPing() {
        return this.ping;
    }

    public ScoreBoard getScoreBoard() {
        return this.scoreboard;
    }

    public AutoRespawn getAutoRespawn() {
        return this.autorespawn;
    }

    public Particles getParticles() {
        return this.particles;
    }
}

