/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.waze;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleEvent;
import fr.weefle.waze.effects.WazeEffectActionBar;
import fr.weefle.waze.effects.WazeEffectBossBarCreate;
import fr.weefle.waze.effects.WazeEffectBossBarRemove;
import fr.weefle.waze.effects.WazeEffectBungee;
import fr.weefle.waze.effects.WazeEffectClearRecipes;
import fr.weefle.waze.effects.WazeEffectRecipe;
import fr.weefle.waze.effects.WazeEffectTitle;
import fr.weefle.waze.events.PlayerJumpEvent;
import fr.weefle.waze.expressions.WazeExpressionPing;
import fr.weefle.waze.nms.ActionBar;
import fr.weefle.waze.nms.ActionBar_1_12_R1;
import fr.weefle.waze.nms.Actionbar_1_11_R1;
import fr.weefle.waze.nms.BossBar;
import fr.weefle.waze.nms.BossBar_1_11_R1;
import fr.weefle.waze.nms.BossBar_1_12_R1;
import fr.weefle.waze.nms.Ping;
import fr.weefle.waze.nms.Ping_1_11_R1;
import fr.weefle.waze.nms.Ping_1_12_R1;
import fr.weefle.waze.nms.Title;
import fr.weefle.waze.nms.Title_1_11_R1;
import fr.weefle.waze.nms.Title_1_12_R1;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Waze
extends JavaPlugin {
    public static Waze instance;
    private ActionBar actionbar;
    private Title title;
    private BossBar bossbar;
    private Ping ping;

    public void onEnable() {
        if (this.setupActionBar()) {
            this.getLogger().info("Actionbar setup was successful!");
            this.getLogger().info("The plugin setup process is complete!");
        } else {
            this.getLogger().severe("Failed to setup Actionbar!");
            this.getLogger().severe("Your server version is not compatible with this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        instance = this;
        PlayerJumpEvent.register(this);
        Skript.registerAddon((JavaPlugin)this);
        Skript.registerEffect(WazeEffectTitle.class, (String[])new String[]{"[waze] (send|create) title %string% with [sub[title]] %string% (to|for) %player% (for|to) %integer% tick[s]"});
        Skript.registerEffect(WazeEffectActionBar.class, (String[])new String[]{"[waze] (send|create) action[bar] %string% (to|for) %player%"});
        Skript.registerEffect(WazeEffectBungee.class, (String[])new String[]{"[waze] (send|teleport) %player% to [bungee[cord]] server %string%"});
        Skript.registerExpression(WazeExpressionPing.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[waze] %player%['s] ping", "[waze] ping of %player%"});
        Skript.registerEffect(WazeEffectRecipe.class, (String[])new String[]{"[waze] (create|register) [new] recipe[s] [for] %itemtype% with %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%, %itemtype%"});
        Skript.registerEffect(WazeEffectClearRecipes.class, (String[])new String[]{"[waze] (remove|clear|delete) [all] [craft[ing]] recipe[s]"});
        Skript.registerEffect(WazeEffectBossBarCreate.class, (String[])new String[]{"[waze] (create|send) [boss]bar %string% (with|at) %float% percent[s] (and|with) color %string% (to|for) %player%"});
        Skript.registerEffect(WazeEffectBossBarRemove.class, (String[])new String[]{"[waze] (remove|delete|clear) boss[bar] (of|for) %player%"});
        Skript.registerEvent((String)"Jump Event", SimpleEvent.class, PlayerJumpEvent.class, (String[])new String[]{"[waze] jump[ing]"});
    }

    private boolean setupActionBar() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return false;
        }
        this.getLogger().info("Your server is running version " + version);
        if (version.equals("v1_12_R1")) {
            this.actionbar = new ActionBar_1_12_R1();
            this.title = new Title_1_12_R1();
            this.bossbar = new BossBar_1_12_R1();
            this.ping = new Ping_1_12_R1();
        } else if (version.equals("v1_11_R1")) {
            this.actionbar = new Actionbar_1_11_R1();
            this.title = new Title_1_11_R1();
            this.bossbar = new BossBar_1_11_R1();
            this.ping = new Ping_1_11_R1();
        }
        return this.actionbar != null;
    }

    public ActionBar getActionbar() {
        return this.actionbar;
    }

    public Title getTitle() {
        return this.title;
    }

    public static Waze getInstance() {
        return instance;
    }

    public BossBar getBossBar() {
        return this.bossbar;
    }

    public Ping getPing() {
        return this.ping;
    }
}

