/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skvault;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.UnparsedLiteral;
import java.util.stream.Stream;

public class LiteralUtils {
    public static <T> Expression<T> defendExpression(Expression<?> expr) {
        if (expr instanceof ExpressionList) {
            Expression[] exprs = ((ExpressionList)expr).getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = LiteralUtils.defendExpression(exprs[i]);
            }
        } else if (expr instanceof UnparsedLiteral) {
            Literal parsedLiteral = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsedLiteral == null ? expr : parsedLiteral;
        }
        return expr;
    }

    private static boolean hasUnparsedLiteral(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            return true;
        }
        if (expr instanceof ExpressionList) {
            return Stream.of(((ExpressionList)expr).getExpressions()).anyMatch(UnparsedLiteral.class::isInstance);
        }
        return false;
    }

    public static boolean canInitSafely(Expression<?> ... expressions) {
        for (int i = 0; i < expressions.length; ++i) {
            if (expressions[i] != null && !LiteralUtils.hasUnparsedLiteral(expressions[i])) continue;
            return false;
        }
        return true;
    }
}

