/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skvault;

import ch.njol.skript.variables.Variables;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skvault.events.requests.BalanceRequestEvent;
import us._donut_.skvault.events.requests.CheckBalanceRequestEvent;
import us._donut_.skvault.events.requests.CreateAccountRequestEvent;
import us._donut_.skvault.events.requests.CurrencyDecimalsRequestEvent;
import us._donut_.skvault.events.requests.DepositRequestEvent;
import us._donut_.skvault.events.requests.EconomyNameRequestEvent;
import us._donut_.skvault.events.requests.EnabledRequestEvent;
import us._donut_.skvault.events.requests.FormatCurrencyRequestEvent;
import us._donut_.skvault.events.requests.HasAccountRequestEvent;
import us._donut_.skvault.events.requests.PluralCurrencyNameRequestEvent;
import us._donut_.skvault.events.requests.SingularCurrencyNameRequestEvent;
import us._donut_.skvault.events.requests.WithdrawRequestEvent;

public class CustomEconomy
extends AbstractEconomy {
    public static boolean automaticLinking = false;
    public static String linkVariable;
    public static String economyName;
    public static String singularCurrencyName;
    public static String pluralCurrencyName;
    public static String currencyFormat;
    public static int currencyDecimals;

    private Object getLinkVariableValue(OfflinePlayer player) {
        String variableName = linkVariable.replace("%player%", player.getName()).replace("%the player%", player.getName()).replace("%player's uuid%", player.getUniqueId().toString()).replace("%uuid of player%", player.getUniqueId().toString()).replace("the UUID of the player", player.getUniqueId().toString());
        return Variables.getVariable((String)variableName, null, (boolean)false);
    }

    private void setLinkVariableValue(OfflinePlayer player, Object value) {
        String variableName = linkVariable.replace("%player%", player.getName()).replace("%the player%", player.getName()).replace("%player's uuid%", player.getUniqueId().toString()).replace("%uuid of player%", player.getUniqueId().toString()).replace("the UUID of the player", player.getUniqueId().toString());
        Variables.setVariable((String)variableName, (Object)value, null, (boolean)false);
    }

    private double getDoubleValue(Object variableValue) {
        try {
            return ((Number)variableValue).doubleValue();
        }
        catch (ClassCastException | NullPointerException e) {
            return 0.0;
        }
    }

    public boolean isEnabled() {
        EnabledRequestEvent event = new EnabledRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return automaticLinking && !event.isImplemented() || event.getBooleanValue();
    }

    public String getName() {
        EconomyNameRequestEvent event = new EconomyNameRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getStringValue() : economyName;
    }

    public int fractionalDigits() {
        CurrencyDecimalsRequestEvent event = new CurrencyDecimalsRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getIntValue() : currencyDecimals;
    }

    public String format(double amount) {
        FormatCurrencyRequestEvent event = new FormatCurrencyRequestEvent(amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getStringValue() : currencyFormat.replace("%number%", String.valueOf(amount));
    }

    public String currencyNameSingular() {
        SingularCurrencyNameRequestEvent event = new SingularCurrencyNameRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getStringValue() : singularCurrencyName;
    }

    public String currencyNamePlural() {
        PluralCurrencyNameRequestEvent event = new PluralCurrencyNameRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getStringValue() : pluralCurrencyName;
    }

    public double getBalance(OfflinePlayer player) {
        BalanceRequestEvent event = new BalanceRequestEvent(player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getDoubleValue() : this.getDoubleValue(this.getLinkVariableValue(player));
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        DepositRequestEvent event = new DepositRequestEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!automaticLinking || event.isImplemented()) {
            return event.getEconomyResponse();
        }
        double newBalance = this.getDoubleValue(this.getLinkVariableValue(player)) + amount;
        this.setLinkVariableValue(player, newBalance);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        WithdrawRequestEvent event = new WithdrawRequestEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!automaticLinking || event.isImplemented()) {
            return event.getEconomyResponse();
        }
        double newBalance = this.getDoubleValue(this.getLinkVariableValue(player)) - amount;
        this.setLinkVariableValue(player, newBalance);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean has(OfflinePlayer player, double amount) {
        CheckBalanceRequestEvent event = new CheckBalanceRequestEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !automaticLinking || event.isImplemented() ? event.getBooleanValue() : this.getDoubleValue(this.getLinkVariableValue(player)) > amount;
    }

    public boolean hasAccount(OfflinePlayer player) {
        HasAccountRequestEvent event = new HasAccountRequestEvent(player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return automaticLinking && !event.isImplemented() || event.getBooleanValue();
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        CreateAccountRequestEvent event = new CreateAccountRequestEvent(player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return automaticLinking && !event.isImplemented() || event.getBooleanValue();
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public double getBalance(String playerName) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)playerName));
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public boolean has(String playerName, double amount) {
        return this.has(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean hasAccount(String playerName) {
        return this.hasAccount(Bukkit.getOfflinePlayer((String)playerName));
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(String playerName) {
        return this.createPlayerAccount(Bukkit.getOfflinePlayer((String)playerName));
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean hasBankSupport() {
        return false;
    }

    static {
        economyName = "";
        singularCurrencyName = "dollar";
        pluralCurrencyName = "dollars";
        currencyFormat = "$%number%";
        currencyDecimals = 2;
    }
}

