/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skvault;

import ch.njol.skript.variables.Variables;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skvault.ConfigManager;
import us._donut_.skvault.events.requests.BalanceRequestEvent;
import us._donut_.skvault.events.requests.CheckBalanceRequestEvent;
import us._donut_.skvault.events.requests.CurrencyDecimalsRequestEvent;
import us._donut_.skvault.events.requests.DepositRequestEvent;
import us._donut_.skvault.events.requests.EconomyNameRequestEvent;
import us._donut_.skvault.events.requests.EnabledRequestEvent;
import us._donut_.skvault.events.requests.WithdrawRequestEvent;

public class CustomEconomy
extends AbstractEconomy {
    private ConfigManager configManager;
    private String linkVariable;

    CustomEconomy(ConfigManager configManager) {
        this.configManager = configManager;
        this.linkVariable = configManager.getLinkVariable();
    }

    private Object getLinkVariableValue(OfflinePlayer player) {
        String variableName = this.linkVariable.replace("%player%", player.getName()).replace("%player's uuid%", player.getUniqueId().toString()).replace("%uuid of player%", player.getUniqueId().toString());
        return Variables.getVariable((String)variableName, null, (boolean)false);
    }

    private void setLinkVariableValue(OfflinePlayer player, Object value) {
        String variableName = this.linkVariable.replace("%player%", player.getName()).replace("%player's uuid%", player.getUniqueId().toString()).replace("%uuid of player%", player.getUniqueId().toString());
        Variables.setVariable((String)variableName, (Object)value, null, (boolean)false);
    }

    private double getDoubleValue(Object variableValue) {
        try {
            return ((Number)variableValue).doubleValue();
        }
        catch (ClassCastException | NullPointerException e) {
            return 0.0;
        }
    }

    public boolean isEnabled() {
        if (this.configManager.isLinkingAutomatic()) {
            return true;
        }
        EnabledRequestEvent event = new EnabledRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getBooleanValue();
    }

    public String getName() {
        if (this.configManager.isLinkingAutomatic()) {
            return this.configManager.getEconomyName();
        }
        EconomyNameRequestEvent event = new EconomyNameRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getStringValue();
    }

    public int fractionalDigits() {
        if (this.configManager.isLinkingAutomatic()) {
            return this.configManager.getCurrencyDecimals();
        }
        CurrencyDecimalsRequestEvent event = new CurrencyDecimalsRequestEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getIntValue();
    }

    public String format(double amount) {
        return this.configManager.getCurrencyFormat().replace("%number%", String.valueOf(amount));
    }

    public String currencyNameSingular() {
        return this.configManager.getCurrencyNameSingular();
    }

    public String currencyNamePlural() {
        return this.configManager.getCurrencyNamePlural();
    }

    public double getBalance(OfflinePlayer player) {
        if (this.configManager.isLinkingAutomatic()) {
            return this.getDoubleValue(this.getLinkVariableValue(player));
        }
        BalanceRequestEvent event = new BalanceRequestEvent(player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getDoubleValue();
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (this.configManager.isLinkingAutomatic()) {
            double newBalance = this.getDoubleValue(this.getLinkVariableValue(player)) + amount;
            this.setLinkVariableValue(player, newBalance);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        DepositRequestEvent event = new DepositRequestEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getEconomyResponse();
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (this.configManager.isLinkingAutomatic()) {
            double newBalance = this.getDoubleValue(this.getLinkVariableValue(player)) - amount;
            this.setLinkVariableValue(player, newBalance);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        WithdrawRequestEvent event = new WithdrawRequestEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getEconomyResponse();
    }

    public boolean has(OfflinePlayer player, double amount) {
        if (this.configManager.isLinkingAutomatic()) {
            return this.getDoubleValue(this.getLinkVariableValue(player)) > amount;
        }
        CheckBalanceRequestEvent event = new CheckBalanceRequestEvent(player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getBooleanValue();
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public double getBalance(String playerName) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)playerName));
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public boolean has(String playerName, double amount) {
        return this.has(Bukkit.getOfflinePlayer((String)playerName), 1.0);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public List<String> getBanks() {
        throw new UnsupportedOperationException("BanksRequest");
    }

    public boolean hasBankSupport() {
        throw new UnsupportedOperationException("BankSupportRequest");
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        throw new UnsupportedOperationException("CreateAccountRequest");
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        throw new UnsupportedOperationException("CreateAccountRequest");
    }

    public boolean createPlayerAccount(String playerName) {
        throw new UnsupportedOperationException("CreateAccountRequest");
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        throw new UnsupportedOperationException("CreateAccountRequest");
    }

    public boolean hasAccount(OfflinePlayer player) {
        throw new UnsupportedOperationException("HasAccountRequest");
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        throw new UnsupportedOperationException("HasAccountRequest");
    }

    public boolean hasAccount(String playerName) {
        throw new UnsupportedOperationException("HasAccountRequest");
    }

    public boolean hasAccount(String playerName, String worldName) {
        throw new UnsupportedOperationException("HasAccountRequest");
    }
}

