/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skvault;

import org.bukkit.configuration.file.FileConfiguration;
import us._donut_.skvault.SkVault;

class ConfigManager {
    private SkVault plugin;
    private FileConfiguration config;

    ConfigManager(SkVault plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.registerDefaults();
    }

    private void registerDefaults() {
        this.config.options().header("Set automatic linking to true for simple automatic handling of Vault requests to your economy\nSet automatic linking to false if you want to be able to handle what happens when Vault requests something from your economy\nSkript uses the currency name and format while parsing your script so they must be predefined here");
        this.config.addDefault("currency_name_singular", (Object)"dollar");
        this.config.addDefault("currency_name_plural", (Object)"dollars");
        this.config.addDefault("currency_format", (Object)"$%number%");
        this.config.addDefault("enable_automatic_linking", (Object)true);
        this.config.addDefault("automatic_linking.balance_variable", (Object)"{balances::%player%}");
        this.config.addDefault("automatic_linking.economy_name", (Object)"Cool Economy");
        this.config.addDefault("automatic_linking.currency_decimal_places", (Object)2);
        this.config.options().copyDefaults(true);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
    }

    String getCurrencyNameSingular() {
        return this.config.getString("currency_name_singular");
    }

    String getCurrencyNamePlural() {
        return this.config.getString("currency_name_plural");
    }

    String getCurrencyFormat() {
        return this.config.getString("currency_format");
    }

    boolean isLinkingAutomatic() {
        return this.config.getBoolean("enable_automatic_linking");
    }

    String getLinkVariable() {
        return this.config.getString("automatic_linking.balance_variable").replace("{", "").replace("}", "");
    }

    String getEconomyName() {
        return this.config.getString("automatic_linking.economy_name");
    }

    int getCurrencyDecimals() {
        return this.config.getInt("automatic_linking.currency_decimal_places");
    }
}

