/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skvault.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.event.Event;
import us._donut_.skvault.events.EcoResponseRequestEvent;

@Name(value="Vault Request - Return Economy Response")
@Description(value={"Returns an economy response to a request from vault"})
@RequiredPlugins(value={"Vault"})
@Since(value="1.0")
public class EffReturnEcoResponse
extends Effect {
    private Expression<Number> amountModified;
    private Expression<Number> newBalance;
    private Expression<String> errorMessage;
    private EconomyResponse.ResponseType responseType;

    public boolean init(Expression<?>[] e, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        for (Class event : ScriptLoader.getCurrentEvents()) {
            if (!ScriptLoader.isCurrentEvent((Class)event) || !event.getSuperclass().equals(EcoResponseRequestEvent.class)) continue;
            this.amountModified = e[0];
            this.newBalance = e[1];
            this.errorMessage = e[2];
            switch (parseResult.mark) {
                case 0: {
                    this.responseType = EconomyResponse.ResponseType.SUCCESS;
                    break;
                }
                case 1: {
                    this.responseType = EconomyResponse.ResponseType.FAILURE;
                    break;
                }
                case 2: {
                    this.responseType = EconomyResponse.ResponseType.NOT_IMPLEMENTED;
                }
            }
            return true;
        }
        Skript.error((String)"You can only use the return economy response effect in a Vault economy response request event");
        return false;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "return economy response";
    }

    protected void execute(Event e) {
        EconomyResponse economyResponse = new EconomyResponse(((Number)this.amountModified.getSingle(e)).doubleValue(), ((Number)this.newBalance.getSingle(e)).doubleValue(), this.responseType, (String)this.errorMessage.getSingle(e));
        ((EcoResponseRequestEvent)e).setEconomyResponse(economyResponse);
    }

    static {
        Skript.registerEffect(EffReturnEcoResponse.class, (String[])new String[]{"return [a] [new] eco[nomy] response [with] [amount [modified]] %number%, [new] [bal[ance]] %number%, [[response] type] (0\u00a6success|1\u00a6failure|2\u00a6not implemented), [and] [error [message] %string% [to [the] [vault] request]"});
    }
}

