/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.slimefun.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.events.bukkit.SkriptStartEvent;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.Category;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import us._donut_.skuniversal.slimefun.SlimefunHook;

@Name(value="Slimefun - Create Category")
@Description(value={"Creates Slimefun category (it will not show up in the guide unless you create at least 1 item for it)"})
@Examples(value={"create slimefun category named \"Cool Stuff\" with menu item dirt named \"Cool Stuff\" with priority 0"})
public class EffCreateCategory
extends Effect {
    private Expression<String> name;
    private Expression<ItemStack> item;
    private Expression<Integer> level;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult p) {
        if (!ScriptLoader.isCurrentEvent(SkriptStartEvent.class)) {
            Skript.error((String)"You can not use Slimefun create category effect in any event but on skript load.");
            return false;
        }
        this.name = e[0];
        this.item = e[1];
        this.level = e[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "create Slimefun category " + this.name.toString(e, b) + " with item " + this.item.toString(e, b) + " with level " + this.level.toString(e, b);
    }

    protected void execute(Event e) {
        if (this.name.getSingle(e) == null || this.item.getSingle(e) == null || this.level.getSingle(e) == null) {
            return;
        }
        SlimefunHook.customCategories.put(((String)this.name.getSingle(e)).toLowerCase(), new Category((ItemStack)this.item.getSingle(e), ((Integer)this.level.getSingle(e)).intValue()));
    }

    static {
        Skript.registerEffect(EffCreateCategory.class, (String[])new String[]{"create [a] [new] [Slimefun] category [(named|with name)] %string% with [menu] item %itemstack% with (level|priority) %integer%"});
    }
}

